/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class CoreAuthenticationData
implements Serializable {
    private final byte[] credentialId;
    private final AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData;
    private final byte[] authenticatorDataBytes;
    private final byte[] clientDataHash;
    private final byte[] signature;

    public CoreAuthenticationData(byte[] credentialId, AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData, byte[] authenticatorDataBytes, byte[] clientDataHash, byte[] signature) {
        this.credentialId = ArrayUtil.clone((byte[])credentialId);
        this.authenticatorData = authenticatorData;
        this.authenticatorDataBytes = ArrayUtil.clone((byte[])authenticatorDataBytes);
        this.clientDataHash = ArrayUtil.clone((byte[])clientDataHash);
        this.signature = ArrayUtil.clone((byte[])signature);
    }

    public byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> getAuthenticatorData() {
        return this.authenticatorData;
    }

    public byte[] getAuthenticatorDataBytes() {
        return ArrayUtil.clone((byte[])this.authenticatorDataBytes);
    }

    public byte[] getClientDataHash() {
        return ArrayUtil.clone((byte[])this.clientDataHash);
    }

    public byte[] getSignature() {
        return ArrayUtil.clone((byte[])this.signature);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreAuthenticationData that = (CoreAuthenticationData)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Objects.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.authenticatorDataBytes, that.authenticatorDataBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash) && Arrays.equals(this.signature, that.signature);
    }

    public int hashCode() {
        int result = Objects.hash(this.authenticatorData);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.authenticatorDataBytes);
        result = 31 * result + Arrays.hashCode(this.clientDataHash);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }
}

