/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.authenticator;

import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.authenticator.CoreAuthenticatorImpl;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class AuthenticatorImpl
extends CoreAuthenticatorImpl
implements Authenticator {
    private AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions;
    private Set<AuthenticatorTransport> transports;

    public AuthenticatorImpl(AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter, Set<AuthenticatorTransport> transports, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticatorExtensions) {
        super(attestedCredentialData, attestationStatement, counter, authenticatorExtensions);
        this.clientExtensions = clientExtensions;
        this.transports = transports;
    }

    public AuthenticatorImpl(AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter, Set<AuthenticatorTransport> transports) {
        this(attestedCredentialData, attestationStatement, counter, transports, new AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput>(), new AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput>());
    }

    public AuthenticatorImpl(AttestedCredentialData attestedCredentialData, AttestationStatement attestationStatement, long counter) {
        this(attestedCredentialData, attestationStatement, counter, Collections.emptySet());
    }

    public static AuthenticatorImpl createFromRegistrationData(RegistrationData registrationData) {
        return new AuthenticatorImpl(registrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData(), registrationData.getAttestationObject().getAttestationStatement(), registrationData.getAttestationObject().getAuthenticatorData().getSignCount(), registrationData.getTransports());
    }

    @Override
    public AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    public void setClientExtensions(AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions) {
        this.clientExtensions = clientExtensions;
    }

    @Override
    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public void setTransports(Set<AuthenticatorTransport> transports) {
        this.transports = transports;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthenticatorImpl that = (AuthenticatorImpl)o;
        return Objects.equals(this.clientExtensions, that.clientExtensions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientExtensions);
    }
}

