/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;

public class AuthenticatorDataDeserializer
extends StdDeserializer<AuthenticatorData> {
    private ObjectConverter objectConverter;

    public AuthenticatorDataDeserializer(ObjectConverter objectConverter) {
        super(AuthenticatorData.class);
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.objectConverter = objectConverter;
    }

    @Deprecated
    public AuthenticatorDataDeserializer(CborConverter cborConverter) {
        super(AuthenticatorData.class);
        AssertUtil.notNull((Object)cborConverter, (String)"cborConverter must not be null");
        this.objectConverter = new ObjectConverter(cborConverter.getJsonConverter(), cborConverter);
    }

    public AuthenticatorData deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        byte[] value = p.getBinaryValue();
        return new AuthenticatorDataConverter(this.objectConverter).convert(value);
    }
}

