/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async;

import com.webauthn4j.async.WebAuthnAuthenticationAsyncManager;
import com.webauthn4j.async.WebAuthnRegistrationAsyncManager;
import com.webauthn4j.async.verifier.AuthenticationDataAsyncVerifier;
import com.webauthn4j.async.verifier.CustomAuthenticationAsyncVerifier;
import com.webauthn4j.async.verifier.CustomRegistrationAsyncVerifier;
import com.webauthn4j.async.verifier.RegistrationDataAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.AttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.androidkey.NullAndroidKeyAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.androidsafetynet.NullAndroidSafetyNetAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.apple.NullAppleAnonymousAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.none.NoneAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.packed.NullPackedAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.tpm.NullTPMAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.statement.u2f.NullFIDOU2FAttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.NullCertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.verifier.exception.VerificationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;

public class WebAuthnAsyncManager {
    private final WebAuthnRegistrationAsyncManager webAuthnRegistrationAsyncManager;
    private final WebAuthnAuthenticationAsyncManager webAuthnAuthenticationAsyncManager;

    public WebAuthnAsyncManager(@NotNull List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers, @NotNull CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier, @NotNull SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier, @NotNull List<CustomRegistrationAsyncVerifier> customRegistrationAsyncVerifiers, @NotNull List<CustomAuthenticationAsyncVerifier> customAuthenticationAsyncVerifiers, @NotNull ObjectConverter objectConverter) {
        this.webAuthnRegistrationAsyncManager = new WebAuthnRegistrationAsyncManager(attestationStatementAsyncVerifiers, certPathTrustworthinessAsyncVerifier, selfAttestationTrustworthinessAsyncVerifier, customRegistrationAsyncVerifiers, objectConverter);
        this.webAuthnAuthenticationAsyncManager = new WebAuthnAuthenticationAsyncManager(customAuthenticationAsyncVerifiers, objectConverter);
    }

    public WebAuthnAsyncManager(@NotNull List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers, @NotNull CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier, @NotNull SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier, @NotNull List<CustomRegistrationAsyncVerifier> customRegistrationAsyncVerifiers, @NotNull List<CustomAuthenticationAsyncVerifier> customAuthenticationAsyncVerifiers) {
        this(attestationStatementAsyncVerifiers, certPathTrustworthinessAsyncVerifier, selfAttestationTrustworthinessAsyncVerifier, customRegistrationAsyncVerifiers, customAuthenticationAsyncVerifiers, new ObjectConverter());
    }

    public WebAuthnAsyncManager(@NotNull List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers, @NotNull CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier, @NotNull SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier, @NotNull ObjectConverter objectConverter) {
        this(attestationStatementAsyncVerifiers, certPathTrustworthinessAsyncVerifier, selfAttestationTrustworthinessAsyncVerifier, new ArrayList<CustomRegistrationAsyncVerifier>(), new ArrayList<CustomAuthenticationAsyncVerifier>(), objectConverter);
    }

    public WebAuthnAsyncManager(@NotNull List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers, @NotNull CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier, @NotNull SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier) {
        this(attestationStatementAsyncVerifiers, certPathTrustworthinessAsyncVerifier, selfAttestationTrustworthinessAsyncVerifier, new ArrayList<CustomRegistrationAsyncVerifier>(), new ArrayList<CustomAuthenticationAsyncVerifier>());
    }

    @NotNull
    public static WebAuthnAsyncManager createNonStrictWebAuthnAsyncManager() {
        ObjectConverter objectConverter = new ObjectConverter();
        return WebAuthnAsyncManager.createNonStrictWebAuthnAsyncManager(objectConverter);
    }

    @NotNull
    public static WebAuthnAsyncManager createNonStrictWebAuthnAsyncManager(@NotNull ObjectConverter objectConverter) {
        return new WebAuthnAsyncManager(Arrays.asList(new NoneAttestationStatementAsyncVerifier(), new NullFIDOU2FAttestationStatementAsyncVerifier(), new NullPackedAttestationStatementAsyncVerifier(), new NullTPMAttestationStatementAsyncVerifier(), new NullAndroidKeyAttestationStatementAsyncVerifier(), new NullAndroidSafetyNetAttestationStatementAsyncVerifier(), new NullAppleAnonymousAttestationStatementAsyncVerifier()), new NullCertPathTrustworthinessAsyncVerifier(), new NullSelfAttestationTrustworthinessAsyncVerifier(), objectConverter);
    }

    @NotNull
    public CompletionStage<RegistrationData> parseRegistrationResponseJSON(@NotNull String registrationResponseJSON) {
        return this.webAuthnRegistrationAsyncManager.parse(registrationResponseJSON);
    }

    @NotNull
    public CompletionStage<RegistrationData> parse(@NotNull RegistrationRequest registrationRequest) throws DataConversionException {
        return this.webAuthnRegistrationAsyncManager.parse(registrationRequest);
    }

    @NotNull
    public CompletionStage<RegistrationData> verifyRegistrationResponseJSON(@NotNull String registrationResponseJSON, @NotNull RegistrationParameters registrationParameters) throws DataConversionException, VerificationException {
        return this.webAuthnRegistrationAsyncManager.verify(registrationResponseJSON, registrationParameters);
    }

    @NotNull
    public CompletionStage<RegistrationData> verify(@NotNull RegistrationRequest registrationRequest, @NotNull RegistrationParameters registrationParameters) throws DataConversionException, VerificationException {
        return this.webAuthnRegistrationAsyncManager.verify(registrationRequest, registrationParameters);
    }

    @NotNull
    public CompletionStage<RegistrationData> verify(@NotNull RegistrationData registrationData, @NotNull RegistrationParameters registrationParameters) throws VerificationException {
        return this.webAuthnRegistrationAsyncManager.verify(registrationData, registrationParameters);
    }

    @NotNull
    public CompletionStage<AuthenticationData> parseAuthenticationResponseJSON(@NotNull String authenticationResponseJSON) throws DataConversionException {
        return this.webAuthnAuthenticationAsyncManager.parse(authenticationResponseJSON);
    }

    @NotNull
    public CompletionStage<AuthenticationData> parse(@NotNull AuthenticationRequest authenticationRequest) throws DataConversionException {
        return this.webAuthnAuthenticationAsyncManager.parse(authenticationRequest);
    }

    @NotNull
    public CompletionStage<AuthenticationData> verifyAuthenticationResponseJSON(@NotNull String authenticationResponseJSON, @NotNull AuthenticationParameters authenticationParameters) throws DataConversionException, VerificationException {
        return this.webAuthnAuthenticationAsyncManager.verify(authenticationResponseJSON, authenticationParameters);
    }

    @NotNull
    public CompletionStage<AuthenticationData> verify(@NotNull AuthenticationRequest authenticationRequest, @NotNull AuthenticationParameters authenticationParameters) throws DataConversionException, VerificationException {
        return this.webAuthnAuthenticationAsyncManager.verify(authenticationRequest, authenticationParameters);
    }

    @NotNull
    public CompletionStage<AuthenticationData> verify(@NotNull AuthenticationData authenticationData, @NotNull AuthenticationParameters authenticationParameters) throws VerificationException {
        return this.webAuthnAuthenticationAsyncManager.verify(authenticationData, authenticationParameters);
    }

    @NotNull
    public RegistrationDataAsyncVerifier getRegistrationDataAsyncVerifier() {
        return this.webAuthnRegistrationAsyncManager.getRegistrationDataAsyncVerifier();
    }

    @NotNull
    public AuthenticationDataAsyncVerifier getAuthenticationDataAsyncVerifier() {
        return this.webAuthnAuthenticationAsyncManager.getAuthenticationDataAsyncVerifier();
    }
}

