/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async.anchor;

import com.webauthn4j.anchor.KeyStoreException;
import com.webauthn4j.async.anchor.TrustAnchorAsyncRepository;
import com.webauthn4j.async.util.internal.FileAsyncUtil;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;

public class KeyStoreTrustAnchorAsyncRepository
implements TrustAnchorAsyncRepository {
    private final CompletableFuture<Set<TrustAnchor>> trustAnchors;

    public KeyStoreTrustAnchorAsyncRepository(KeyStore keyStore) {
        AssertUtil.notNull((Object)keyStore, (String)"keyStore must not be null");
        this.trustAnchors = CompletableFuture.completedFuture(KeyStoreTrustAnchorAsyncRepository.loadTrustAnchors(keyStore));
    }

    public static CompletionStage<KeyStoreTrustAnchorAsyncRepository> createFromKeyStoreFilePath(Path keyStore, String password) {
        return KeyStoreTrustAnchorAsyncRepository.loadKeyStore(keyStore, password).thenApply(KeyStoreTrustAnchorAsyncRepository::new);
    }

    @Override
    public CompletionStage<Set<TrustAnchor>> find(AAGUID aaguid) {
        return this.trustAnchors;
    }

    @Override
    public CompletionStage<Set<TrustAnchor>> find(byte[] attestationCertificateKeyIdentifier) {
        return this.trustAnchors;
    }

    @NotNull
    private static Set<TrustAnchor> loadTrustAnchors(KeyStore keyStore) {
        try {
            ArrayList<String> aliases = Collections.list(keyStore.aliases());
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            for (String alias : aliases) {
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                trustAnchors.add(new TrustAnchor(certificate, null));
            }
            return trustAnchors;
        }
        catch (java.security.KeyStoreException e) {
            throw new KeyStoreException("Failed to load TrustAnchor from keystore", (Throwable)e);
        }
    }

    @NotNull
    private static CompletionStage<KeyStore> loadKeyStore(Path keyStore, String password) {
        AssertUtil.notNull((Object)keyStore, (String)"keyStore must not be null");
        AssertUtil.notNull((Object)password, (String)"password must not be null");
        return FileAsyncUtil.load(keyStore).thenCompose(bytes -> {
            CompletableFuture<KeyStore> completableFuture;
            ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])bytes);
            try {
                KeyStore keyStoreObject = CertificateUtil.createKeyStore();
                keyStoreObject.load(inputStream, password.toCharArray());
                completableFuture = CompletableFuture.completedFuture(keyStoreObject);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                    throw new KeyStoreException("Failed to load TrustAnchor from keystore", (Throwable)e);
                }
            }
            ((InputStream)inputStream).close();
            return completableFuture;
        });
    }
}

