/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.appattest.verifier;

import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.CoreRegistrationObject;
import java.time.Instant;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DCRegistrationObject
extends CoreRegistrationObject {
    private final byte[] keyId;

    public DCRegistrationObject(@NotNull byte[] keyId, @NotNull AttestationObject attestationObject, @NotNull byte[] attestationObjectBytes, @NotNull byte[] clientDataHash, @NotNull CoreServerProperty serverProperty, @NotNull Instant timestamp) {
        super(attestationObject, attestationObjectBytes, clientDataHash, serverProperty, timestamp);
        AssertUtil.notNull((Object)keyId, (String)"keyId must not be null");
        this.keyId = ArrayUtil.clone((byte[])keyId);
    }

    public DCRegistrationObject(@NotNull byte[] keyId, @NotNull AttestationObject attestationObject, @NotNull byte[] attestationObjectBytes, @NotNull byte[] clientDataHash, @NotNull CoreServerProperty serverProperty) {
        super(attestationObject, attestationObjectBytes, clientDataHash, serverProperty);
        AssertUtil.notNull((Object)keyId, (String)"keyId must not be null");
        this.keyId = ArrayUtil.clone((byte[])keyId);
    }

    @NotNull
    public byte[] getKeyId() {
        return ArrayUtil.clone((byte[])this.keyId);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DCRegistrationObject that = (DCRegistrationObject)((Object)o);
        return Arrays.equals(this.keyId, that.keyId);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.keyId);
        return result;
    }
}

