/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.linkis.cs.persistence.persistence.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webank.wedatasphere.linkis.cs.common.entity.source.ContextID;
import com.webank.wedatasphere.linkis.cs.common.exception.CSErrorException;
import com.webank.wedatasphere.linkis.cs.persistence.dao.ContextIDMapper;
import com.webank.wedatasphere.linkis.cs.persistence.entity.ExtraFieldClass;
import com.webank.wedatasphere.linkis.cs.persistence.entity.PersistenceContextID;
import com.webank.wedatasphere.linkis.cs.persistence.persistence.ContextIDPersistence;
import com.webank.wedatasphere.linkis.cs.persistence.util.PersistenceUtils;
import com.webank.wedatasphere.linkis.server.BDPJettyServerHelper;
import java.io.IOException;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextIDPersistenceImpl
implements ContextIDPersistence {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ContextIDMapper contextIDMapper;
    private Class<PersistenceContextID> pClass = PersistenceContextID.class;
    private ObjectMapper json = BDPJettyServerHelper.jacksonJson();

    @Override
    public ContextID createContextID(ContextID contextID) throws CSErrorException {
        try {
            Pair<PersistenceContextID, ExtraFieldClass> pContextID = PersistenceUtils.transfer(contextID, this.pClass);
            ((PersistenceContextID)pContextID.getFirst()).setSource(this.json.writeValueAsString(pContextID.getSecond()));
            this.contextIDMapper.createContextID((PersistenceContextID)pContextID.getFirst());
            contextID.setContextId(((PersistenceContextID)pContextID.getFirst()).getContextId());
            return contextID;
        }
        catch (JsonProcessingException e) {
            this.logger.error("writeAsJson failed:", (Throwable)e);
            throw new CSErrorException(97000, e.getMessage());
        }
    }

    @Override
    public void deleteContextID(String contextId) {
        this.contextIDMapper.deleteContextID(contextId);
    }

    @Override
    public void updateContextID(ContextID contextID) throws CSErrorException {
        Pair<PersistenceContextID, ExtraFieldClass> pContextID = PersistenceUtils.transfer(contextID, this.pClass);
        this.contextIDMapper.updateContextID((PersistenceContextID)pContextID.getFirst());
    }

    @Override
    public ContextID getContextID(String contextId) throws CSErrorException {
        try {
            PersistenceContextID pContextID = this.contextIDMapper.getContextID(contextId);
            if (pContextID == null) {
                return null;
            }
            ExtraFieldClass extraFieldClass = (ExtraFieldClass)this.json.readValue(pContextID.getSource(), ExtraFieldClass.class);
            ContextID contextID = (ContextID)PersistenceUtils.transfer(extraFieldClass, pContextID);
            return contextID;
        }
        catch (IOException e) {
            this.logger.error("readJson failed:", (Throwable)e);
            throw new CSErrorException(97000, e.getMessage());
        }
    }
}

