/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.linkis.cs.persistence.persistence.impl;

import com.webank.wedatasphere.linkis.cs.common.entity.listener.CommonContextIDListenerDomain;
import com.webank.wedatasphere.linkis.cs.common.entity.listener.ContextIDListenerDomain;
import com.webank.wedatasphere.linkis.cs.common.entity.source.ContextID;
import com.webank.wedatasphere.linkis.cs.common.exception.CSErrorException;
import com.webank.wedatasphere.linkis.cs.persistence.dao.ContextIDListenerMapper;
import com.webank.wedatasphere.linkis.cs.persistence.entity.PersistenceContextIDListener;
import com.webank.wedatasphere.linkis.cs.persistence.persistence.ContextIDListenerPersistence;
import com.webank.wedatasphere.linkis.cs.persistence.persistence.ContextIDPersistence;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextIDListenerPersistenceImpl
implements ContextIDListenerPersistence {
    @Autowired
    private ContextIDListenerMapper contextIDListenerMapper;
    @Autowired
    private ContextIDPersistence contextIDPersistence;

    @Override
    public void create(ContextID contextID, ContextIDListenerDomain contextIDListenerDomain) throws CSErrorException {
        PersistenceContextIDListener listener = new PersistenceContextIDListener();
        listener.setContextId(contextID.getContextId());
        listener.setSource(contextIDListenerDomain.getSource());
        this.contextIDListenerMapper.createIDListener(listener);
    }

    @Override
    public void remove(ContextIDListenerDomain contextIDListenerDomain) throws CSErrorException {
        PersistenceContextIDListener listener = new PersistenceContextIDListener();
        listener.setContextId(contextIDListenerDomain.getContextID().getContextId());
        listener.setSource(contextIDListenerDomain.getSource());
        this.contextIDListenerMapper.remove(listener);
    }

    @Override
    public void removeAll(ContextID contextID) throws CSErrorException {
        this.contextIDListenerMapper.removeAll(contextID);
    }

    @Override
    public List<ContextIDListenerDomain> getAll(ContextID contextID) throws CSErrorException {
        ContextID complete = this.contextIDPersistence.getContextID(contextID.getContextId());
        List<PersistenceContextIDListener> listeners = this.contextIDListenerMapper.getAll(contextID);
        List<ContextIDListenerDomain> domains = listeners.stream().map(l -> this.pDomainToCommon((PersistenceContextIDListener)l, complete)).collect(Collectors.toList());
        return domains;
    }

    public ContextIDListenerDomain pDomainToCommon(PersistenceContextIDListener listener, ContextID contextID) {
        CommonContextIDListenerDomain domain = new CommonContextIDListenerDomain();
        domain.setContextID(contextID);
        domain.setSource(listener.getSource());
        return domain;
    }

    @Override
    public ContextIDListenerDomain getBy(ContextIDListenerDomain contextIDListenerDomain) throws CSErrorException {
        return contextIDListenerDomain;
    }
}

