/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.linkis.cs.persistence.persistence.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.webank.wedatasphere.linkis.cs.common.entity.history.ContextHistory;
import com.webank.wedatasphere.linkis.cs.common.entity.source.ContextID;
import com.webank.wedatasphere.linkis.cs.common.exception.CSErrorException;
import com.webank.wedatasphere.linkis.cs.persistence.dao.ContextHistoryMapper;
import com.webank.wedatasphere.linkis.cs.persistence.entity.ExtraFieldClass;
import com.webank.wedatasphere.linkis.cs.persistence.entity.PersistenceContextHistory;
import com.webank.wedatasphere.linkis.cs.persistence.persistence.ContextHistoryPersistence;
import com.webank.wedatasphere.linkis.cs.persistence.util.PersistenceUtils;
import com.webank.wedatasphere.linkis.server.BDPJettyServerHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextHistoryPersistenceImpl
implements ContextHistoryPersistence {
    @Autowired
    private ContextHistoryMapper contextHistoryMapper;
    private ObjectMapper json = BDPJettyServerHelper.jacksonJson();
    private Class<PersistenceContextHistory> pClass = PersistenceContextHistory.class;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void createHistory(ContextID contextID, ContextHistory contextHistory) throws CSErrorException {
        Pair<PersistenceContextHistory, ExtraFieldClass> pHistroy = PersistenceUtils.transfer(contextHistory, this.pClass);
        ((PersistenceContextHistory)pHistroy.getFirst()).setHistoryJson(PersistenceUtils.serialize(contextHistory));
        ((PersistenceContextHistory)pHistroy.getFirst()).setContextId(contextID.getContextId());
        this.contextHistoryMapper.createHistory((PersistenceContextHistory)pHistroy.getFirst());
    }

    @Override
    public List<ContextHistory> getHistories(ContextID contextID) throws CSErrorException {
        List<PersistenceContextHistory> pHistories = this.contextHistoryMapper.getHistoriesByContextID(contextID);
        return pHistories.stream().map(PersistenceUtils.map(this::transfer)).collect(Collectors.toList());
    }

    public ContextHistory transfer(PersistenceContextHistory pHistory) throws CSErrorException {
        ContextHistory history = (ContextHistory)PersistenceUtils.deserialize(pHistory.getHistoryJson());
        return history;
    }

    @Override
    public ContextHistory getHistory(ContextID contextID, Long id) throws CSErrorException {
        PersistenceContextHistory pHistory = this.contextHistoryMapper.getHistory(contextID, id);
        return pHistory == null ? null : this.transfer(pHistory);
    }

    @Override
    public ContextHistory getHistory(ContextID contextID, String source) throws CSErrorException {
        PersistenceContextHistory pHistory = this.contextHistoryMapper.getHistoryBySource(contextID, source);
        return pHistory == null ? null : this.transfer(pHistory);
    }

    @Override
    public void removeHistory(ContextID contextID, String source) throws CSErrorException {
        this.contextHistoryMapper.removeHistory(contextID, source);
    }

    @Override
    public void updateHistory(ContextID contextID, ContextHistory contextHistory) throws CSErrorException {
        Pair<PersistenceContextHistory, ExtraFieldClass> pHistroy = PersistenceUtils.transfer(contextHistory, this.pClass);
        this.contextHistoryMapper.updateHistory(contextID, (PersistenceContextHistory)pHistroy.getFirst());
    }
}

