/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.linkis.cs.persistence.aop;

import com.webank.wedatasphere.linkis.DataWorkCloudApplication;
import com.webank.wedatasphere.linkis.cs.persistence.conf.PersistenceConf;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PersistenceTuningAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean tuningIsOpen = false;
    private Object tuningObject = null;
    private Method tuningMethod = null;
    private boolean isInited = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        PersistenceTuningAspect persistenceTuningAspect = this;
        synchronized (persistenceTuningAspect) {
            if (!this.isInited) {
                try {
                    Class<?> tuningClass = this.getClass().getClassLoader().loadClass((String)PersistenceConf.TUNING_CLASS.getValue());
                    ApplicationContext context = DataWorkCloudApplication.getApplicationContext();
                    if (context != null) {
                        try {
                            this.tuningObject = context.getBean(tuningClass);
                            this.logger.info("find singleton tuning Object from IOC");
                        }
                        catch (NoSuchBeanDefinitionException e) {
                            this.logger.info("can not find singleton  tuning Object from IOC");
                        }
                    }
                    if (this.tuningObject == null) {
                        this.tuningObject = tuningClass.newInstance();
                    }
                    this.tuningMethod = tuningClass.getMethod((String)PersistenceConf.TUNING_METHOD.getValue(), Object.class);
                    this.tuningIsOpen = true;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                    this.logger.warn("can not load tuning class,tuning is close", (Throwable)e);
                }
                finally {
                    this.isInited = true;
                }
            }
        }
    }

    @Pointcut(value="@annotation(com.webank.wedatasphere.linkis.cs.persistence.annotation.Tuning)")
    private void cut() {
    }

    @Around(value="cut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        if (!this.isInited) {
            this.init();
        }
        if (!this.tuningIsOpen) {
            this.logger.info("tuning is close..return the real");
            return point.proceed();
        }
        Signature signature = point.getSignature();
        if (!(signature instanceof MethodSignature)) {
            throw new IllegalArgumentException("This annotation can only be used for methods(\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5)");
        }
        MethodSignature methodSignature = (MethodSignature)signature;
        Object target = point.getTarget();
        Method currentMethod = target.getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
        this.logger.info("call method (\u8c03\u7528\u65b9\u6cd5)\uff1a" + currentMethod.getName());
        return this.tuningMethod.invoke(this.tuningObject, point.proceed());
    }
}

