/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.time;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.wdullaer.materialdatetimepicker.time.Timepoint;
import com.wdullaer.materialdatetimepicker.time.TimepointLimiter;
import java.util.Arrays;
import java.util.TreeSet;

class DefaultTimepointLimiter
implements TimepointLimiter {
    private TreeSet<Timepoint> mSelectableTimes = new TreeSet();
    private TreeSet<Timepoint> mDisabledTimes = new TreeSet();
    private TreeSet<Timepoint> exclusiveSelectableTimes = new TreeSet();
    private Timepoint mMinTime;
    private Timepoint mMaxTime;
    public static final Parcelable.Creator<DefaultTimepointLimiter> CREATOR = new Parcelable.Creator<DefaultTimepointLimiter>(){

        public DefaultTimepointLimiter createFromParcel(Parcel in) {
            return new DefaultTimepointLimiter(in);
        }

        public DefaultTimepointLimiter[] newArray(int size) {
            return new DefaultTimepointLimiter[size];
        }
    };

    DefaultTimepointLimiter() {
    }

    public DefaultTimepointLimiter(Parcel in) {
        this.mMinTime = (Timepoint)in.readParcelable(Timepoint.class.getClassLoader());
        this.mMaxTime = (Timepoint)in.readParcelable(Timepoint.class.getClassLoader());
        this.mSelectableTimes.addAll(Arrays.asList((Timepoint[])in.readParcelableArray(Timepoint[].class.getClassLoader())));
        this.mDisabledTimes.addAll(Arrays.asList((Timepoint[])in.readParcelableArray(Timepoint[].class.getClassLoader())));
        this.exclusiveSelectableTimes = this.getExclusiveSelectableTimes(this.mSelectableTimes, this.mDisabledTimes);
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.mMinTime, flags);
        out.writeParcelable((Parcelable)this.mMaxTime, flags);
        out.writeParcelableArray((Parcelable[])((Timepoint[])this.mSelectableTimes.toArray()), flags);
        out.writeParcelableArray((Parcelable[])((Timepoint[])this.mDisabledTimes.toArray()), flags);
    }

    public int describeContents() {
        return 0;
    }

    void setMinTime(@NonNull Timepoint minTime) {
        if (this.mMaxTime != null && minTime.compareTo(this.mMaxTime) > 0) {
            throw new IllegalArgumentException("Minimum time must be smaller than the maximum time");
        }
        this.mMinTime = minTime;
    }

    void setMaxTime(@NonNull Timepoint maxTime) {
        if (this.mMinTime != null && maxTime.compareTo(this.mMinTime) < 0) {
            throw new IllegalArgumentException("Maximum time must be greater than the minimum time");
        }
        this.mMaxTime = maxTime;
    }

    void setSelectableTimes(@NonNull Timepoint[] selectableTimes) {
        this.mSelectableTimes.addAll(Arrays.asList(selectableTimes));
        this.exclusiveSelectableTimes = this.getExclusiveSelectableTimes(this.mSelectableTimes, this.mDisabledTimes);
    }

    void setDisabledTimes(@NonNull Timepoint[] disabledTimes) {
        this.mDisabledTimes.addAll(Arrays.asList(disabledTimes));
        this.exclusiveSelectableTimes = this.getExclusiveSelectableTimes(this.mSelectableTimes, this.mDisabledTimes);
    }

    private TreeSet<Timepoint> getExclusiveSelectableTimes(TreeSet<Timepoint> selectable, TreeSet<Timepoint> disabled) {
        TreeSet output = (TreeSet)selectable.clone();
        output.removeAll(disabled);
        return output;
    }

    @Override
    public boolean isOutOfRange(@Nullable Timepoint current, int index, @NonNull Timepoint.TYPE resolution) {
        if (current == null) {
            return false;
        }
        if (index == 0) {
            if (this.mMinTime != null && this.mMinTime.getHour() > current.getHour()) {
                return true;
            }
            if (this.mMaxTime != null && this.mMaxTime.getHour() + 1 <= current.getHour()) {
                return true;
            }
            if (!this.exclusiveSelectableTimes.isEmpty()) {
                Timepoint ceil = this.exclusiveSelectableTimes.ceiling(current);
                Timepoint floor = this.exclusiveSelectableTimes.floor(current);
                return !current.equals(ceil, Timepoint.TYPE.HOUR) && !current.equals(floor, Timepoint.TYPE.HOUR);
            }
            if (!this.mDisabledTimes.isEmpty() && resolution == Timepoint.TYPE.HOUR) {
                Timepoint ceil = this.mDisabledTimes.ceiling(current);
                Timepoint floor = this.mDisabledTimes.floor(current);
                return current.equals(ceil, Timepoint.TYPE.HOUR) || current.equals(floor, Timepoint.TYPE.HOUR);
            }
            return false;
        }
        if (index == 1) {
            Timepoint ceil;
            Timepoint roundedMax;
            Timepoint roundedMin;
            if (this.mMinTime != null && (roundedMin = new Timepoint(this.mMinTime.getHour(), this.mMinTime.getMinute())).compareTo(current) > 0) {
                return true;
            }
            if (this.mMaxTime != null && (roundedMax = new Timepoint(this.mMaxTime.getHour(), this.mMaxTime.getMinute(), 59)).compareTo(current) < 0) {
                return true;
            }
            if (!this.exclusiveSelectableTimes.isEmpty()) {
                ceil = this.exclusiveSelectableTimes.ceiling(current);
                Timepoint floor = this.exclusiveSelectableTimes.floor(current);
                return !current.equals(ceil, Timepoint.TYPE.MINUTE) && !current.equals(floor, Timepoint.TYPE.MINUTE);
            }
            if (!this.mDisabledTimes.isEmpty() && resolution == Timepoint.TYPE.MINUTE) {
                ceil = this.mDisabledTimes.ceiling(current);
                Timepoint floor = this.mDisabledTimes.floor(current);
                boolean ceilExclude = current.equals(ceil, Timepoint.TYPE.MINUTE);
                boolean floorExclude = current.equals(floor, Timepoint.TYPE.MINUTE);
                return ceilExclude || floorExclude;
            }
            return false;
        }
        return this.isOutOfRange(current);
    }

    public boolean isOutOfRange(@NonNull Timepoint current) {
        if (this.mMinTime != null && this.mMinTime.compareTo(current) > 0) {
            return true;
        }
        if (this.mMaxTime != null && this.mMaxTime.compareTo(current) < 0) {
            return true;
        }
        if (!this.exclusiveSelectableTimes.isEmpty()) {
            return !this.exclusiveSelectableTimes.contains(current);
        }
        return this.mDisabledTimes.contains(current);
    }

    @Override
    public boolean isAmDisabled() {
        Timepoint midday = new Timepoint(12);
        if (this.mMinTime != null && this.mMinTime.compareTo(midday) >= 0) {
            return true;
        }
        if (!this.exclusiveSelectableTimes.isEmpty()) {
            return this.exclusiveSelectableTimes.first().compareTo(midday) >= 0;
        }
        return false;
    }

    @Override
    public boolean isPmDisabled() {
        Timepoint midday = new Timepoint(12);
        if (this.mMaxTime != null && this.mMaxTime.compareTo(midday) < 0) {
            return true;
        }
        if (!this.exclusiveSelectableTimes.isEmpty()) {
            return this.exclusiveSelectableTimes.last().compareTo(midday) < 0;
        }
        return false;
    }

    @Override
    @NonNull
    public Timepoint roundToNearest(@NonNull Timepoint time, @Nullable Timepoint.TYPE type, @NonNull Timepoint.TYPE resolution) {
        if (this.mMinTime != null && this.mMinTime.compareTo(time) > 0) {
            return this.mMinTime;
        }
        if (this.mMaxTime != null && this.mMaxTime.compareTo(time) < 0) {
            return this.mMaxTime;
        }
        if (type == Timepoint.TYPE.SECOND) {
            return time;
        }
        if (!this.exclusiveSelectableTimes.isEmpty()) {
            int ceilDist;
            int floorDist;
            Timepoint floor = this.exclusiveSelectableTimes.floor(time);
            Timepoint ceil = this.exclusiveSelectableTimes.ceiling(time);
            if (floor == null || ceil == null) {
                Timepoint t;
                Timepoint timepoint = t = floor == null ? ceil : floor;
                if (type == null) {
                    return t;
                }
                if (t.getHour() != time.getHour()) {
                    return time;
                }
                if (type == Timepoint.TYPE.MINUTE && t.getMinute() != time.getMinute()) {
                    return time;
                }
                return t;
            }
            if (type == Timepoint.TYPE.HOUR) {
                if (floor.getHour() != time.getHour() && ceil.getHour() == time.getHour()) {
                    return ceil;
                }
                if (floor.getHour() == time.getHour() && ceil.getHour() != time.getHour()) {
                    return floor;
                }
                if (floor.getHour() != time.getHour() && ceil.getHour() != time.getHour()) {
                    return time;
                }
            }
            if (type == Timepoint.TYPE.MINUTE) {
                if (floor.getHour() != time.getHour() && ceil.getHour() != time.getHour()) {
                    return time;
                }
                if (floor.getHour() != time.getHour() && ceil.getHour() == time.getHour()) {
                    return ceil.getMinute() == time.getMinute() ? ceil : time;
                }
                if (floor.getHour() == time.getHour() && ceil.getHour() != time.getHour()) {
                    return floor.getMinute() == time.getMinute() ? floor : time;
                }
                if (floor.getMinute() != time.getMinute() && ceil.getMinute() == time.getMinute()) {
                    return ceil;
                }
                if (floor.getMinute() == time.getMinute() && ceil.getMinute() != time.getMinute()) {
                    return floor;
                }
                if (floor.getMinute() != time.getMinute() && ceil.getMinute() != time.getMinute()) {
                    return time;
                }
            }
            return (floorDist = Math.abs(time.compareTo(floor))) < (ceilDist = Math.abs(time.compareTo(ceil))) ? floor : ceil;
        }
        if (!this.mDisabledTimes.isEmpty()) {
            if (type != null && type == resolution) {
                return time;
            }
            if (resolution == Timepoint.TYPE.SECOND) {
                if (!this.mDisabledTimes.contains(time)) {
                    return time;
                }
                return this.searchValidTimePoint(time, type, resolution);
            }
            if (resolution == Timepoint.TYPE.MINUTE) {
                Timepoint ceil = this.mDisabledTimes.ceiling(time);
                Timepoint floor = this.mDisabledTimes.floor(time);
                boolean ceilDisabled = time.equals(ceil, Timepoint.TYPE.MINUTE);
                boolean floorDisabled = time.equals(floor, Timepoint.TYPE.MINUTE);
                if (ceilDisabled || floorDisabled) {
                    return this.searchValidTimePoint(time, type, resolution);
                }
                return time;
            }
            if (resolution == Timepoint.TYPE.HOUR) {
                Timepoint ceil = this.mDisabledTimes.ceiling(time);
                Timepoint floor = this.mDisabledTimes.floor(time);
                boolean ceilDisabled = time.equals(ceil, Timepoint.TYPE.HOUR);
                boolean floorDisabled = time.equals(floor, Timepoint.TYPE.HOUR);
                if (ceilDisabled || floorDisabled) {
                    return this.searchValidTimePoint(time, type, resolution);
                }
                return time;
            }
        }
        return time;
    }

    private Timepoint searchValidTimePoint(@NonNull Timepoint time, @Nullable Timepoint.TYPE type, @NonNull Timepoint.TYPE resolution) {
        Timepoint forward = new Timepoint(time);
        Timepoint backward = new Timepoint(time);
        int iteration = 0;
        int resolutionMultiplier = 1;
        if (resolution == Timepoint.TYPE.MINUTE) {
            resolutionMultiplier = 60;
        }
        if (resolution == Timepoint.TYPE.SECOND) {
            resolutionMultiplier = 3600;
        }
        while (iteration < 24 * resolutionMultiplier) {
            ++iteration;
            forward.add(resolution, 1);
            backward.add(resolution, -1);
            if (type == null || forward.get(type) == time.get(type)) {
                Timepoint forwardCeil = this.mDisabledTimes.ceiling(forward);
                Timepoint forwardFloor = this.mDisabledTimes.floor(forward);
                if (!forward.equals(forwardCeil, resolution) && !forward.equals(forwardFloor, resolution)) {
                    return forward;
                }
            }
            if (type == null || backward.get(type) == time.get(type)) {
                Timepoint backwardCeil = this.mDisabledTimes.ceiling(backward);
                Timepoint backwardFloor = this.mDisabledTimes.floor(backward);
                if (!backward.equals(backwardCeil, resolution) && !backward.equals(backwardFloor, resolution)) {
                    return backward;
                }
            }
            if (type == null || backward.get(type) == time.get(type) || forward.get(type) == time.get(type)) continue;
            break;
        }
        return time;
    }
}

