/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.time;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;

public class Timepoint
implements Parcelable,
Comparable<Timepoint> {
    private int hour;
    private int minute;
    private int second;
    public static final Parcelable.Creator<Timepoint> CREATOR = new Parcelable.Creator<Timepoint>(){

        public Timepoint createFromParcel(Parcel in) {
            return new Timepoint(in);
        }

        public Timepoint[] newArray(int size) {
            return new Timepoint[size];
        }
    };

    public Timepoint(Timepoint time) {
        this(time.hour, time.minute, time.second);
    }

    public Timepoint(int hour, int minute, int second) {
        this.hour = hour % 24;
        this.minute = minute % 60;
        this.second = second % 60;
    }

    public Timepoint(int hour, int minute) {
        this(hour, minute, 0);
    }

    public Timepoint(int hour) {
        this(hour, 0);
    }

    public Timepoint(Parcel in) {
        this.hour = in.readInt();
        this.minute = in.readInt();
        this.second = in.readInt();
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public boolean isAM() {
        return this.hour < 12;
    }

    public boolean isPM() {
        return this.hour >= 12 && this.hour < 24;
    }

    public void setAM() {
        if (this.hour >= 12) {
            this.hour %= 12;
        }
    }

    public void setPM() {
        if (this.hour < 12) {
            this.hour = (this.hour + 12) % 24;
        }
    }

    public boolean equals(Object o) {
        try {
            Timepoint other = (Timepoint)o;
            return other.getHour() == this.hour && other.getMinute() == this.minute && other.getSecond() == this.second;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int compareTo(@NonNull Timepoint t) {
        return (this.hour - t.hour) * 3600 + (this.minute - t.minute) * 60 + (this.second - t.second);
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.hour);
        out.writeInt(this.minute);
        out.writeInt(this.second);
    }

    public int describeContents() {
        return 0;
    }

    public static enum TYPE {
        HOUR,
        MINUTE,
        SECOND;

    }
}

