/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.uxkit.incoming;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.ParticipantNotification;
import com.voxeet.sdk.push.center.invitation.IIncomingInvitationListener;
import com.voxeet.sdk.push.center.invitation.InvitationBundle;
import com.voxeet.sdk.utils.AndroidManifest;
import com.voxeet.sdk.utils.Opt;
import com.voxeet.uxkit.incoming.IncomingFullScreen;
import com.voxeet.uxkit.incoming.IncomingNotificationConfiguration;
import com.voxeet.uxkit.incoming.R;
import com.voxeet.uxkit.incoming.factory.IVoxeetActivity;
import com.voxeet.uxkit.incoming.factory.IncomingCallFactory;
import com.voxeet.uxkit.incoming.manifest.DismissNotificationBroadcastReceiver;
import java.security.SecureRandom;

public class IncomingNotification
implements IIncomingInvitationListener {
    private static final String SDK_CHANNEL_ID = "voxeet_sdk_channel_id";
    private static final String DEFAULT_ID = "VideoConference";
    public static final int INCOMING_NOTIFICATION_REQUEST_CODE = 928;
    private static final String TAG = IncomingNotification.class.getSimpleName();
    public static final String EXTRA_NOTIFICATION_ID = "EXTRA_NOTIFICATION_ID";
    public static final IncomingNotificationConfiguration Configuration = new IncomingNotificationConfiguration();
    private SecureRandom random = new SecureRandom();
    private int notificationId = -1;

    public String getIncomingAcceptedClass(@NonNull Context context) {
        return AndroidManifest.readMetadata((Context)context, (String)"voxeet_incoming_accepted_class", null);
    }

    public void onInvitation(@NonNull Context context, @NonNull InvitationBundle invitationBundle) {
        this.notificationId = this.random.nextInt(0x3FFFFFFF);
        if (null != invitationBundle.conferenceId) {
            this.notificationId = invitationBundle.conferenceId.hashCode();
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        String channelId = IncomingNotification.getChannelId(context);
        Intent accept = this.createIntent(context, invitationBundle);
        Intent dismiss = this.createDismissIntent(context, invitationBundle);
        if (null != accept) {
            accept.putExtra(EXTRA_NOTIFICATION_ID, this.notificationId);
        }
        dismiss.putExtra(EXTRA_NOTIFICATION_ID, this.notificationId);
        if (null == accept) {
            Log.d((String)TAG, (String)"onInvitation: accept intent is null !! did you set the voxeet_incoming_accepted_class prop");
            return;
        }
        PendingIntent pendingIntentAccepted = PendingIntent.getActivity((Context)context, (int)928, (Intent)accept, (int)0x10000000);
        PendingIntent pendingIntentDismissed = PendingIntent.getBroadcast((Context)context, (int)928, (Intent)dismiss, (int)0x8000000);
        String inviterName = (String)Opt.of((Object)invitationBundle.inviter).then(ParticipantNotification::getInfo).then(ParticipantInfo::getName).or((Object)"");
        Notification lastNotification = new NotificationCompat.Builder(context, channelId).setPriority(1).setContentTitle((CharSequence)context.getString(R.string.voxeet_incoming_notification_from_user, new Object[]{inviterName})).setContentText((CharSequence)context.getString(R.string.voxeet_incoming_notification_accept)).setSmallIcon(R.drawable.ic_incoming_call_notification).addAction(R.drawable.ic_incoming_call_dismiss, (CharSequence)context.getString(R.string.voxeet_incoming_notification_button_dismiss), pendingIntentDismissed).addAction(R.drawable.ic_incoming_call_accept, (CharSequence)context.getString(R.string.voxeet_incoming_notification_button_accept), pendingIntentAccepted).setAutoCancel(IncomingNotification.Configuration.IsAutoCancel).setOngoing(IncomingNotification.Configuration.IsOnGoing).build();
        notificationManager.notify(this.notificationId, lastNotification);
    }

    @Nullable
    private Intent createIntent(@NonNull Context context, @NonNull InvitationBundle invitationBundle) {
        String klass_fully_qualified;
        Bundle extra = invitationBundle.asBundle();
        Class<IVoxeetActivity> klass = IncomingCallFactory.getAcceptedIncomingActivityKlass();
        if (null == klass && null != (klass_fully_qualified = this.getIncomingAcceptedClass(context))) {
            try {
                klass = Class.forName(klass_fully_qualified);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (null == klass) {
            return null;
        }
        Intent intent = new Intent(context, klass);
        Bundle extras = IncomingCallFactory.getAcceptedIncomingActivityExtras();
        if (null != extras) {
            intent.putExtras(extras);
        }
        for (String key : IncomingFullScreen.DEFAULT_NOTIFICATION_KEYS) {
            if (!extra.containsKey(key)) continue;
            intent.putExtra(key, extra.getString(key));
        }
        return intent;
    }

    @NonNull
    private Intent createDismissIntent(@NonNull Context context, @NonNull InvitationBundle invitationBundle) {
        Bundle extra = invitationBundle.asBundle();
        Intent intent = new Intent(context, DismissNotificationBroadcastReceiver.class);
        for (String key : IncomingFullScreen.DEFAULT_NOTIFICATION_KEYS) {
            if (!extra.containsKey(key)) continue;
            intent.putExtra(key, extra.getString(key));
        }
        return intent;
    }

    public void onInvitationCanceled(@NonNull Context context, @NonNull String conferenceId) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (-1 != this.notificationId) {
            notificationManager.cancel(this.notificationId);
        }
        this.notificationId = 0;
    }

    public static String getChannelId(@NonNull Context context) {
        return AndroidManifest.readMetadata((Context)context, (String)SDK_CHANNEL_ID, (String)DEFAULT_ID);
    }
}

