/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.uxkit.incoming;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.sdk.factories.VoxeetIntentFactory;
import com.voxeet.sdk.push.center.invitation.IIncomingInvitationListener;
import com.voxeet.sdk.push.center.invitation.InvitationBundle;
import com.voxeet.sdk.utils.AndroidManifest;

public class IncomingFullScreen
implements IIncomingInvitationListener {
    public static final String[] DEFAULT_NOTIFICATION_KEYS = new String[]{"UserId", "DisplayName", "NotifType", "ExternalId", "AvatarUrl", "ConfId"};
    @NonNull
    private Class<? extends Activity> incomingCallClass;

    private IncomingFullScreen() {
    }

    public IncomingFullScreen(@NonNull Class<? extends Activity> incomingCallClass) {
        this();
        this.incomingCallClass = incomingCallClass;
    }

    @SuppressLint(value={"WrongConstant"})
    public void onInvitation(@NonNull Context context, @NonNull InvitationBundle invitationBundle) {
        String voxeet_default_incoming = AndroidManifest.readMetadata((Context)context, (String)"voxeet_incoming_class", null);
        Log.d((String)"NotificationCenterFactory", (String)("onInvitation: " + voxeet_default_incoming));
        Bundle extra = invitationBundle.asBundle();
        Class<? extends Activity> newClass = VoxeetIntentFactory.createClass((String)voxeet_default_incoming);
        if (null == newClass) {
            newClass = this.incomingCallClass;
        }
        Intent intent = new Intent();
        intent.setClass(context, newClass);
        for (String key : DEFAULT_NOTIFICATION_KEYS) {
            if (!extra.containsKey(key)) continue;
            intent.putExtra(key, extra.getString(key));
        }
        intent.putExtra("join", true);
        intent.putExtra("callMode", 1);
        intent.addFlags(4);
        intent.addFlags(0x10000000);
        intent.addFlags(0x280080);
        context.startActivity(intent);
    }

    public void onInvitationCanceled(@NonNull Context context, @NonNull String conferenceId) {
    }
}

