package com.voxeet.sdk.utils;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.ViewConfiguration;
import android.view.WindowManager;

public class ScreenHelper {

    public static int actionBar(Context context) {
        final TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(
                new int[]{android.R.attr.actionBarSize});
        int mActionBarSize = (int) styledAttributes.getDimension(0, 0);
        styledAttributes.recycle();
        return mActionBarSize;
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static Point getScreenSize(@NonNull Context context) {
        try {
            Point size = new Point();
            Display d = ((WindowManager) (context.getSystemService(Context.WINDOW_SERVICE))).getDefaultDisplay();

            DisplayMetrics realDisplayMetrics = new DisplayMetrics();
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                d.getRealMetrics(realDisplayMetrics);
                size.x = realDisplayMetrics.widthPixels;
                size.y = realDisplayMetrics.heightPixels;
            } else {
                d.getSize(size);
            }
            return size;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new Point();
    }

    public static boolean hasSoftKeys(@NonNull Context context) {
        //from https://readyandroid.wordpress.com/above-lollipop-api-bottom-navigation-bar-overlays-app/
        boolean hasSoftwareKeys = true;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Display d = ((WindowManager) (context.getSystemService(Context.WINDOW_SERVICE))).getDefaultDisplay();

            DisplayMetrics realDisplayMetrics = new DisplayMetrics();
            d.getRealMetrics(realDisplayMetrics);

            int realHeight = realDisplayMetrics.heightPixels;
            int realWidth = realDisplayMetrics.widthPixels;

            DisplayMetrics displayMetrics = new DisplayMetrics();
            d.getMetrics(displayMetrics);

            int displayHeight = displayMetrics.heightPixels;
            int displayWidth = displayMetrics.widthPixels;

            hasSoftwareKeys = (realWidth - displayWidth) > 0 || (realHeight - displayHeight) > 0;
        } else {
            boolean hasMenuKey = ViewConfiguration.get(context).hasPermanentMenuKey();
            boolean hasBackKey = KeyCharacterMap.deviceHasKey(KeyEvent.KEYCODE_BACK);
            hasSoftwareKeys = !hasMenuKey && !hasBackKey;
        }
        return hasSoftwareKeys;
    }

    public static Rect resolveNavigationBarDimenIssueAboveLollipop(@NonNull Context context) {
        Rect rect = new Rect(0, 0, 0, 0);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            WindowManager manager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
            switch (manager.getDefaultDisplay().getRotation()) {
                case Surface.ROTATION_90:
                    rect.right += getNavBarWidth(context);
                    break;
                case Surface.ROTATION_180:
                    rect.top += getNavBarHeight(context);
                    break;
                case Surface.ROTATION_270:
                    rect.left += getNavBarWidth(context);
                    break;
                default:
                    rect.bottom += getNavBarHeight(context);
            }
        }
        return rect;
    }

    private static int getNavBarWidth(@NonNull Context context) {
        return getNavBarDimen(context, "navigation_bar_width");
    }

    private static int getNavBarHeight(@NonNull Context context) {
        return getNavBarDimen(context, "navigation_bar_height");
    }

    private static int getNavBarDimen(@NonNull Context context, String resourceString) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier(resourceString, "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }
}
