package com.voxeet.sdk.services.telemetry.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.VoxeetSDK;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiTelemetry;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.telemetry.TelemetryAnswer;
import com.voxeet.sdk.telemetry.WebRTCStats;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;

import org.greenrobot.eventbus.EventBus;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class WebRTCStatsPromise extends AbstractPromiseable<TelemetryAnswer<Boolean>, IRestApiTelemetry> {

    private final WebRTCStats webRtcStats;

    public WebRTCStatsPromise(@NonNull ConferenceService parent,
                              @NonNull MediaDeviceService mediaDeviceService,
                              @NonNull IRestApiTelemetry provider,
                              @Nullable ConferenceInformation information,
                              @NonNull EventBus eventBus,
                              @NonNull WebRTCStats webRtcStats) {
        super(parent, mediaDeviceService, provider, information, eventBus);

        this.webRtcStats = webRtcStats;
    }

    @NonNull
    @Override
    public Promise<TelemetryAnswer<Boolean>> createPromise() {
        return new Promise<>(solver -> {
            //send an error if you're not in a conference

            final okhttp3.MediaType JSON = okhttp3.MediaType.parse("application/json");
            RequestBody body = RequestBody.create(JSON, webRtcStats.toJson().toString());

            final Call<ResponseBody> user = getApiRestCall().upload("webrtc",
                    webRtcStats.conferenceId,
                    VoxeetSDK.session().getParticipantId(),
                    System.currentTimeMillis(),
                    body);

            long original = System.currentTimeMillis();

            HttpHelper.enqueue(user, (response, object, exception) -> {
                if (null != exception) {
                    solver.reject(HttpHelper.manageThrowableOrServerError(exception, ServerErrorOrigin.TELEMETRY));
                } else {
                    int code = Opt.of(response).then(Response::code).or(0);

                    solver.resolve(new TelemetryAnswer<>(
                            original,
                            Opt.of(response).then(Response::headers).orNull(),
                            code >= 200 && code < 300
                    ));
                }
            });
        });
    }
}
