package com.voxeet.sdk.services.telemetry.device;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.Display;
import android.view.WindowManager;

import com.voxeet.sdk.utils.Map;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.TimeZone;

public class HardwareInfo {

    private static final String[] EXPECTED = new String[]{
            "model_name",
            "cpu_model",
            "hardware"
    };
    private final long ram;
    private final Point screen;

    public HardwareInfo(@NonNull Context context) {
        ActivityManager actManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        actManager.getMemoryInfo(memInfo);
        ram = memInfo.totalMem;

        WindowManager window = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        Display display = window.getDefaultDisplay();
        screen = new Point();
        display.getSize(screen);
    }

    public long ram() {
        return ram;
    }

    public long width() {
        return screen.x;
    }

    public long height() {
        return screen.y;
    }

    public String deviceName() {
        return Build.DEVICE;
    }

    public String tz() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getDisplayName(true, TimeZone.SHORT).replace("GMT", "UTC");
    }

    public String cpu() {
        String cpu_name = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader("/proc/cpuinfo"));
            String str;
            while ((str = br.readLine()) != null) {
                String[] data = str.split(":");
                if (data.length > 1) {
                    String key = data[0].trim().replace(" ", "_");

                    if (Map.isInInsensitive(key, EXPECTED)) {
                        String value = data[1].trim();
                        cpu_name = value.replaceAll("\\s+", " ");
                    }
                }
            }
            br.close();
        } catch (Exception e) {

        }
        return cpu_name;

    }

    public String os() {
        return "android " + Build.VERSION.SDK_INT;
    }

    public String osName() {
        return "android";
    }

    public long version() {
        return Build.VERSION.SDK_INT;
    }
}
