package com.voxeet.sdk.services.simulcast;

import android.support.annotation.NonNull;
import android.util.Log;

import com.voxeet.sdk.utils.Annotate;

/**
 * The ParticipantQuality model enables choosing quality of Simulcast video streams received by conference participants.
 */
@Annotate
public class ParticipantQuality {
    public final static String ALL = "*";

    /**
     * Participant's ID.
     */
    public final String id;

    /**
     * Expected Participant's video quality
     */
    public final Quality quality;

    /**
     * Creates a holder to set the quality of received Simulcast video streams for all conference participants.
     * @param quality expected quality for all conference participants that are not set in the same call
     */
    public ParticipantQuality(@NonNull Quality quality) {
        this(ALL, quality);
    }

    /**
     * Creates a holder to set the quality of received Simulcast video streams for specific conference participants.
     * @param id participant ID
     * @param quality expected quality for the specific conference participant
     */
    public ParticipantQuality(@NonNull String id, @NonNull Quality quality) {
        Log.d("ParticipantQuality", "create for " + id + " " + quality);
        this.id = id;
        this.quality = quality;
    }
}
