package com.voxeet.sdk.services.presentation.file;

import android.support.annotation.NonNull;

import com.voxeet.sdk.services.presentation.PresentationState;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Emitted when the state of the file presentation is changed. It is a class representation information that enables to track various file presentations presented during the conference. It includes the following information:
 *
 * - the key of the file presentation
 * - the URL used by the file presentation
 * - the current state of the file presentation
 */
@Annotate
public class FilePresentation {

    /**
     * Represent the unique key for the presentation. This must be treated as a Primary key to differentiate presentations.
     */
    public final String key;

    /**
     * The url to manipulate the presentation
     * <p>
     * only passed normally hen the presentation is started. This way developers can track and manage the lifecycle
     */
    public final String url;

    /**
     * The current state of the presentation informing about status changes after usage of certain methods.
     */
    public PresentationState state;

    /**
     * The currently displayed page.
     */
    public int page;

    /**
     * The number of pages inside the corresponding FilePresentation instance.
     */
    public int nbPage;

    @NoDocumentation
    private FilePresentation() {
        key = "";
        url = "";
        page = 0;
    }

    @NoDocumentation
    public FilePresentation(@NonNull String key, @NonNull String url) {
        this.key = key;
        this.url = url;
        page = 0;
    }

    @NoDocumentation
    public FilePresentation clone() {
        FilePresentation information = new FilePresentation(key, url);
        information.state = state;
        return information;
    }
}
