package com.voxeet.sdk.services.notification.internal;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.EventNames;
import com.voxeet.sdk.push.center.subscription.event.ConferenceEndedNotificationEvent;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;
import com.voxeet.sdk.utils.Opt;

@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONFERENCE_ENDED_NOTIFICATION)
public class WebSocketConferenceEnded extends Event {

    @NonNull
    public EventConference conference;

    public ConferenceEndedNotificationEvent to() {
        return new ConferenceEndedNotificationEvent(
                Opt.of(conference).then(c -> c.conferenceId).or(""),
                Opt.of(conference).then(c -> c.conferenceAlias).or(""));
    }

    @NonNull
    @Override
    public String getType() {
        return EventNames.CONFERENCE_ENDED_NOTIFICATION;
    }
}