package com.voxeet.sdk.services.notification.events;

import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.EventNames;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.ParticipantNotification;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.services.notification.internal.EventParticipant;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.Map;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Opt;

import java.util.ArrayList;
import java.util.List;

@Annotate
public class ConferenceStatusNotificationEvent {

    @Nullable
    public final String conferenceId;

    @Nullable
    public final String conferenceAlias;

    @Nullable
    public final boolean isLive;

    @Nullable
    public final long startTimestamp;

    public final List<ParticipantNotification> participants;

    private ConferenceStatusNotificationEvent() {
        this.conferenceId = "";
        this.conferenceAlias = "";
        this.isLive = false;
        this.startTimestamp = 0;
        this.participants = new ArrayList<>();
    }

    public ConferenceStatusNotificationEvent(@Nullable String conferenceId,
                                             @Nullable String conferenceAlias,
                                             boolean isLive,
                                             long startTimestamp,
                                             List<ParticipantNotification> participants) {
        this.conferenceId = conferenceId;
        this.conferenceAlias = conferenceAlias;
        this.isLive = isLive;
        this.startTimestamp = startTimestamp;
        this.participants = participants;
    }
}
