package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.promise.Promise;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.network.endpoints.IRestApiOutConference;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;

import org.greenrobot.eventbus.EventBus;

import okhttp3.ResponseBody;
import retrofit2.Call;

public class SubscribeForCallStartPromiseable extends AbstractPromiseable<Boolean, IRestApiOutConference> {

    public SubscribeForCallStartPromiseable(@NonNull ConferenceService parent,
                                            @NonNull MediaDeviceService mediaDeviceService,
                                            @NonNull IRestApiOutConference provider,
                                            @Nullable ConferenceInformation information,
                                            @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(solver -> {
            String id = Opt.of(getInformation()).then(ConferenceInformation::getConference).then(Conference::getId).or("");
            Call<ResponseBody> call = getApiRestCall().subscribeForCall(id);
            HttpHelper.enqueue(call, (response, object, exception) -> {
                if (null != exception) {
                    solver.reject(exception);
                } else {
                    solver.resolve(true);
                }
            });
        });
    }
}
