package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.error.SubscribeConferenceErrorEvent;
import com.voxeet.sdk.models.v1.SubscribeConference;
import com.voxeet.sdk.network.endpoints.IRestApiOutConference;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import retrofit2.Call;

public class SubscribeConferenceEventPromiseable extends AbstractPromiseable<Boolean, IRestApiOutConference> {

    private final String conferenceAlias;

    public SubscribeConferenceEventPromiseable(@NonNull ConferenceService parent,
                                               @NonNull MediaDeviceService mediaDeviceService,
                                               @NonNull IRestApiOutConference provider,
                                               @Nullable String conferenceAlias,
                                               @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, null, eventBus);
        this.conferenceAlias = conferenceAlias;
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(solver -> {
            final Call<SubscribeConference> call = getApiRestCall().subscribe(conferenceAlias);
            HttpHelper.enqueue(call, (response, object, exception) -> {
                if (null != exception) {
                    getEventBus().post(new SubscribeConferenceErrorEvent(getParent().handleError(exception)));
                    solver.reject(exception);
                } else {
                    log("You are no subscribed to this mConference's events");

                    solver.resolve(true);
                }
            });
        });
    }
}
