package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.voxeet.android.media.MediaEngineException;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.ThenPromise;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.sdk.StopVideoAnswerEvent;
import com.voxeet.sdk.events.v2.VideoStateEvent;
import com.voxeet.sdk.json.StopVideoResponse;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiVideo;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceInformationHolder;
import com.voxeet.sdk.services.media.VideoState;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import retrofit2.Call;

public class StopVideoPromise extends AbstractPromiseable<Boolean, IRestApiVideo> {
    private final static String TAG = StopVideoPromise.class.getSimpleName();
    private final ConferenceInformationHolder conferenceInformationHolder;

    public StopVideoPromise(@NonNull ConferenceService parent,
                            @NonNull MediaDeviceService mediaDeviceService,
                            @NonNull IRestApiVideo provider,
                            @Nullable ConferenceInformation information,
                            @NonNull EventBus eventBus,
                            @NonNull ConferenceInformationHolder conferenceInformationHolder) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.conferenceInformationHolder = conferenceInformationHolder;
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(solver -> {
            log("stoppping video");

            MediaSDK media = getMedia();
            final ConferenceInformation information = getInformation();

            if (null == media) {
                Log.d(TAG, "stopVideo: media is null");
                Promise.reject(solver, new MediaEngineException("media is null"));
                return;
            }

            media.stopVideo();


            if (null == information || !getParent().isInConference()) {
                Log.d(TAG, "stopVideo: not in conf");

                Promise.reject(solver, new NotInConferenceException());
                return;
            }

            information.setRequestedOwnVideo(false);

            if (!VideoState.STARTED.equals(information.getVideoState())) {
                log("stopping video failed : maybe already in some...");
                Promise.reject(solver, new IllegalStateException("can not stop video, pending ?"));
                return;
            }
            conferenceInformationHolder.setVideoState(information, VideoState.STOPPING);
            getEventBus().post(new VideoStateEvent(information.getConference(), VideoState.STOPPING));

            String conferenceId = information.getConference().getId();

            final Call<StopVideoResponse> stopVideo = getApiRestCall().stopVideo(conferenceId, VoxeetPreferences.id());

            HttpHelper.promise(stopVideo, ServerErrorOrigin.STOP_VIDEO)
                    .then((ThenPromise<HttpHelper.HttpAnswer<StopVideoResponse>, Boolean>) answer -> {
                        StopVideoResponse object = answer.object;
                        media.stopVideo();

                        information.setRequestedOwnVideo(false);

                        final StopVideoAnswerEvent event = new StopVideoAnswerEvent(true);
                        getEventBus().post(event);
                        return createVideoAnswer(object.participantId, object.description, object.candidates);
                    })
                    .then(result -> {
                        conferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                        getEventBus().post(new VideoStateEvent(information.getConference(), VideoState.STOPPED));
                        //TODO check for possible call in the createVideoAnswer (callback ?)
                        solver.resolve(result);
                    })
                    .error(error -> {
                        conferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                        getEventBus().post(new VideoStateEvent(information.getConference(), VideoState.STOPPED));
                        solver.reject(error);
                    });
        });
    }
}
