package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.network.endpoints.IRestApiMessaging;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import okhttp3.ResponseBody;
import retrofit2.Call;

public class SendBroadcastMessagePromise extends AbstractPromiseable<Boolean, IRestApiMessaging> {

    private final String message;
    private final String conferenceId;

    public SendBroadcastMessagePromise(@NonNull ConferenceService parent,
                                       @NonNull MediaDeviceService mediaDeviceService,
                                       @NonNull IRestApiMessaging provider,
                                       @Nullable ConferenceInformation information,
                                       @NonNull EventBus eventBus,
                                       @NonNull String conferenceId,
                                       @NonNull String message) {
        super(parent, mediaDeviceService, provider, information, eventBus);

        this.conferenceId = conferenceId;
        this.message = message;
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(solver -> {
            if (null == conferenceId) {
                Promise.reject(solver, new NotInConferenceException());
                return;
            }

            final Call<ResponseBody> call = getApiRestCall().broadcastMessage(conferenceId, new BroadcastEvent(message));
            HttpHelper.enqueue(call, (response, object, exception) -> {
                if (null != exception) {
                    solver.reject(exception);
                } else {
                    solver.resolve(true);
                }
            });
        });
    }
}
