package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.ThenVoid;
import com.voxeet.sdk.events.sdk.ConferenceHistoryResult;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v1.HistoryConference;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiOutConference;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;

import org.greenrobot.eventbus.EventBus;

import java.util.List;

import retrofit2.Call;

public class GetConferenceHistoryPromiseable extends AbstractPromiseable<ConferenceHistoryResult, IRestApiOutConference> {

    public GetConferenceHistoryPromiseable(@NonNull ConferenceService parent,
                                           @NonNull MediaDeviceService mediaDeviceService,
                                           @NonNull IRestApiOutConference provider,
                                           @Nullable ConferenceInformation information,
                                           @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<ConferenceHistoryResult> createPromise() {
        return new Promise<>(solver -> {
            String id = Opt.of(getInformation()).then(ConferenceInformation::getConference).then(Conference::getId).or("");
            final Call<List<HistoryConference>> user = getApiRestCall().conferenceHistory(id);

            HttpHelper.promise(user, ServerErrorOrigin.CONFERENCE_HISTORY)
                    .then((ThenVoid<HttpHelper.HttpAnswer<List<HistoryConference>>>) answer -> solver.resolve(new ConferenceHistoryResult(answer.object)))
                    .error(solver::reject);
        });
    }
}
