package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import android.util.Log;

import com.voxeet.promise.solve.ThenVoid;
import com.voxeet.sdk.events.sdk.ConferenceTimeoutNoParticipantsJoinedEvent;

import org.greenrobot.eventbus.EventBus;

class TimeoutRunnable implements Runnable {

    @NonNull
    private EventBus mEventBus; //initialized with parametered-constructor

    @NonNull
    ConferenceService mService; //initialized with parametered-constructor

    private long mTimeout;
    private boolean mCanceled;
    private boolean mTriggered;

    /**
     * Default constructor, make the runnable "not canceled" by default
     * and triggered is false
     */
    private TimeoutRunnable() {
        setCanceled(false);
        mTriggered = false;
    }

    /**
     * @param service   the service which will be called back
     * @param event_bus the configured event bus
     * @param timeout   the current timeout
     */
    TimeoutRunnable(@NonNull ConferenceService service, @NonNull EventBus event_bus, long timeout) {
        this();

        mService = service;
        mEventBus = event_bus;
        mTimeout = timeout;
    }

    void setCanceled(boolean canceled) {
        mCanceled = canceled;
    }

    private boolean isCanceled() {
        return mCanceled;
    }

    @Override
    public void run() {

        if (!isCanceled()) {
            mService.leave()
                    .then((ThenVoid<Boolean>) (result) -> Log.d("TimeoutRunnable", "run: auto leave"))
                    .error(Throwable::printStackTrace);

            //conference was left after Xms
            //note that if you change the timeout after calling the join, the
            //value returned is absolutely inaccurate
            mEventBus.post(new ConferenceTimeoutNoParticipantsJoinedEvent(mTimeout));
            mTriggered = true;
        }
    }

    boolean isTriggered() {
        return mTriggered;
    }
}
