package com.voxeet.sdk.network.endpoints;

import com.voxeet.sdk.services.telemetry.device.DeviceStats;
import com.voxeet.sdk.services.telemetry.rest.TelemetryConfiguration;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public interface IRestApiTelemetry {

    @GET("/api/v1/metrics/configuration")
    Call<TelemetryConfiguration> configuration();

    @PUT("/api/v1/metrics/{type}/users/{userId}/timestamp/{timestamp}")
    Call<ResponseBody> upload(@Path("type") String type,
                              @Path("userId") String userId,
                              @Path("timestamp") long timestamp,
                              @Body DeviceStats url);

    @PUT("/api/v1/metrics/{type}/conferences/{conferenceId}/users/{userId}/timestamp/{timestamp}")
    Call<ResponseBody> upload(@Path("type") String type,
                              @Path("conferenceId") String conferenceId,
                              @Path("userId") String userId,
                              @Path("timestamp") long timestamp,
                              @Body RequestBody url);

    @POST("/api/v1/metrics/{type}/conferences/{conferenceId}/users/{userId}")
    Call<ResponseBody> upload(@Path("type") String type,
                              @Path("conferenceId") String conferenceId,
                              @Path("userId") String userId,
                              @Body RequestBody url);

}
