package com.voxeet.sdk.network.endpoints;

import android.support.annotation.NonNull;

import com.voxeet.sdk.services.simulcast.ParticipantQuality;

import java.util.ArrayList;
import java.util.List;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface IRestApiSimulcast {

    @POST("/v1/conferences/{conferenceId}/simulcast")
    @Headers({"Content-Type: application/json", "Accept: application/json"})
    Call<Boolean> simulcast(@Path("conferenceId") String conferenceId,
                            @Body ParticipantExpectedQualityBody params);

    class ParticipantExpectedQualityBody {

        @NonNull
        public List<ParticipantQuality> requested;

        public ParticipantExpectedQualityBody() {
            this(new ArrayList<>());
        }

        public ParticipantExpectedQualityBody(@NonNull List<ParticipantQuality> requested) {
            this.requested = requested;
        }
    }

}
