package com.voxeet.sdk.network.endpoints;

import com.voxeet.sdk.media.peer.SdpDescription;
import com.voxeet.sdk.models.v1.CandidatesPush;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface IRestApiMedia {


    @POST("v1/conferences/{conferenceId}/answer/{user_id}")
    Call<ResponseBody> answerConference(@Path("conferenceId") String conferenceId, @Path("user_id") String id, @Body SdpDescription description);

    @POST("v1/conferences/{id}/candidates/{peerId}")
    Call<ResponseBody> candidates(@Path("id") String conferenceId,
                                  @Path("peerId") String peerId,
                                  @Body CandidatesPush body);

    @GET("v1/conferences/{id}/renegociate")
    Call<ResponseBody> renegociate(@Path("id") String conferenceId);

    @GET("v1/conferences/{id}/icerestart")
    Call<ResponseBody> iceRestart(@Path("id") String conferenceId);

}
