package com.voxeet.sdk.models.v2;

import android.support.annotation.Nullable;

import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

import java.util.HashMap;

/**
 * The ChatMessageType model represents the types of messages sent via chat. Only the [text](/documentation/sdk/reference/android/models/chatmessagetype#text) message is currently available.
 */
@Annotate
public enum ChatMessageType {
    TEXT("text");

    private static boolean init = false;
    private static HashMap<String, ChatMessageType> map = new HashMap<>();
    private static ChatMessageType[] VALUES = new ChatMessageType[]{
            TEXT
    };

    private final String text;

    @NoDocumentation
    ChatMessageType(String text) {
        this.text = text;
    }

    @NoDocumentation
    public static ChatMessageType fromString(String text) {
        checkInit();
        return map.get(text);
    }

    private static void checkInit() {
        if (!init) {
            for (ChatMessageType type : VALUES) {
                map.put(type.text, type);
            }
            init = true;
        }
    }

    /**
     * Gets the content of the chat message.
     * @return the content of the message or a null value if the message does not contain any content or it is empty.
     */
    @Nullable
    public String text() {
        return text;
    }
}
