package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Emitted when the specific video is started.
 */
@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.VIDEO_PRESENTATION_STARTED)
public class VideoPresentationStarted extends Event {

    /**
     * Represents the key of the current video.
     */
    public String key;

    /**
     * The conference ID.
     */
    public String conferenceId;

    /**
     * The creator of the request.
     */
    @JsonProperty("userId")
    public String participantId;

    /**
     * Represents the date.
     */
    public long timestamp;

    /**
     * The URL of the video location.
     */
    public String url;

    @NoDocumentation
    public VideoPresentationStarted() {

    }

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.VIDEO_PRESENTATION_STARTED;
    }
}
