package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;
import com.voxeet.sdk.utils.NoDocumentation;

@Annotate
@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.PARTICIPANT_UPDATED)
public class ParticipantUpdated extends Event {

    @JsonProperty("conference_id")
    public String conferenceId;

    @JsonProperty("user_id")
    public String participantId;

    @JsonProperty("status")
    public String status;

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.PARTICIPANT_UPDATED;
    }
}
