package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

//TODO confirm with @raphael about the participantId

/**
 * Event fired when an participant has join the conference elsewhere
 */
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.PARTICIPANT_SWITCH)
public class ParticipantSwitched extends Event {

    /**
     * The participant id
     */
    @JsonProperty("user_id")
    public String userId;

    /**
     * The conference id corresponding to this event
     */
    @JsonProperty("conference_id")
    public String conferenceId;

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.PARTICIPANT_SWITCH;
    }
}
