package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.File;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.FILE_CONVERTED)
public class FileConverted extends Event {
    private List<File> files;

    private String errorMessage;

    public List<File> getFiles() {
        return files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    @Override
    public String getType() {
        return EventNames.FILE_CONVERTED;
    }

    public boolean isSuccess() {
        return CONVERSION_SUCCEEDED.equals(errorMessage);
    }

    public static String CONVERSION_SUCCEEDED = "CONVERSION_SUCCEDED";
}
