package com.voxeet.sdk.exceptions;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class VoxeetSentry implements ExceptionListener {

    private final static String TAG = VoxeetSentry.class.getSimpleName();
    private final static String CLASS = "com.voxeet.sentry.VoxeetSentry";
    private final static String METHOD = "onException";

    private VoxeetSentry() {

    }

    @Nullable
    private Object sentry;

    private Method onException;

    public VoxeetSentry(@NonNull Context context) {
        this();

        sentry = getVoxeetSentry(context);
        if (null != sentry) onException = getOnException(sentry);

        Log.d(TAG, "VoxeetSentry: sentry := " + sentry);
        Log.d(TAG, "VoxeetSentry: onException := " + onException);
    }

    @Override
    public void onException(@NonNull Throwable throwable) {
        try {
            if (null != sentry && null != onException) {
                onException.invoke(sentry, throwable);
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    private Method getOnException(@NonNull Object sentry) {
        try {
            return sentry.getClass().getDeclaredMethod(METHOD, Throwable.class);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    private static Object getVoxeetSentry(@NonNull Context context) {
        try {
            Class klass = Class.forName(CLASS);

            Constructor ctor = klass.getDeclaredConstructor(Context.class);
            return ctor.newInstance(context);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}
