package com.voxeet.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.EventNames;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

import java.util.List;

@Deprecated
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONFERENCE_UPDATED)
public class ConferenceUpdated extends Event {

    private String conferenceId;

    private String conferenceAlias;

    private boolean isLive;

    private long startTimestamp;

    private List<ConferenceUser> participants;

    public ConferenceUpdated() {

    }

    public ConferenceUpdated(String conferenceId, String conferenceAlias, boolean isLive, long startTimestamp, List<ConferenceUser> participants) {
        this.conferenceId = conferenceId;
        this.conferenceAlias = conferenceAlias;
        this.isLive = isLive;
        this.startTimestamp = startTimestamp;
        this.participants = participants;
    }

    public List<ConferenceUser> getParticipants() {
        return participants;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public String getConferenceAlias() {
        return conferenceAlias;
    }

    public long getStartTimestamp() {
        return startTimestamp;
    }

    public boolean isLive() {
        return isLive;
    }

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.CONFERENCE_UPDATED;
    }
}
