package com.voxeet.sdk;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.VoxeetSDK;
import com.voxeet.sdk.authent.token.RefreshTokenCallback;
import com.voxeet.sdk.services.AudioService;
import com.voxeet.sdk.services.ChatService;
import com.voxeet.sdk.services.CommandService;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.FilePresentationService;
import com.voxeet.sdk.services.LocalStatsService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.NotificationService;
import com.voxeet.sdk.services.RecordingService;
import com.voxeet.sdk.services.ScreenShareService;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.TelemetryService;
import com.voxeet.sdk.services.VideoPresentationService;
import com.voxeet.sdk.utils.AbstractVoxeetEnvironmentHolder;

import org.greenrobot.eventbus.EventBus;

/**
 * VoxeetSDK is the main object providing methods that interact with the Voxeet service. It is the entry point to call the embedded services and the static elements provided to the developers. The SDK is asynchronous and uses promise at its core.
 * <p>
 * **Typical application workflow:**
 * <p>
 * **1.** The application accesses the Voxeet SDK instance by calling the [instance](/documentation/sdk/reference/android/voxeetsdk#instance) method.
 * <p>
 * **2.** The application initializes the Voxeet SDK through the [initialize](/documentation/sdk/reference/android/voxeetsdk#initialize) method.
 * <p>
 * **3.** The application uses the proper method to retrieve the unique instance for a service that will be used (such as using the [conference](/documentation/sdk/reference/android/voxeetsdk#conference) method to retrieve the [ConferenceService](/documentation/sdk/reference/android/conference) instance).
 * <p>
 * **4.** To use the EventBus, the application calls the [getEventBus](/documentation/sdk/reference/android/voxeetsdk#geteventbus) method to retrieve its unique instance. Then, it calls the [register](/documentation/sdk/reference/android/voxeetsdk#register) method to register the object into the EventBus and the [unregister](/documentation/sdk/reference/android/voxeetsdk#unregister) to unregister from the instance.
 */
@Deprecated
public final class VoxeetSdk {

    @Deprecated
    @NonNull
    public static VoxeetSDK instance() {
        return VoxeetSDK.instance();
    }

    @Deprecated
    public static synchronized void initialize(@NonNull String appId,
                                               @NonNull String password) {
        VoxeetSDK.initialize(appId, password);
    }

    @Deprecated
    public static synchronized void initialize(@NonNull String accessToken,
                                               @NonNull RefreshTokenCallback refreshToken) {
        VoxeetSDK.initialize(accessToken, refreshToken);
    }

    @Deprecated
    @NonNull
    public static ChatService chat() {
        return VoxeetSDK.chat();
    }

    @Deprecated
    @NonNull
    public static ConferenceService conference() {
        return VoxeetSDK.conference();
    }

    @Deprecated
    @NonNull
    public static MediaDeviceService mediaDevice() {
        return VoxeetSDK.mediaDevice();
    }

    @Deprecated
    @NonNull
    public static ScreenShareService screenShare() {
        return VoxeetSDK.screenShare();
    }

    @Deprecated
    @NonNull
    public static SessionService session() {
        return VoxeetSDK.session();
    }

    @Deprecated
    @NonNull
    public static FilePresentationService filePresentation() {
        return VoxeetSDK.filePresentation();
    }

    @Deprecated
    @NonNull
    public static VideoPresentationService videoPresentation() {
        return VoxeetSDK.videoPresentation();
    }

    @Deprecated
    @NonNull
    public static AudioService audio() {
        return VoxeetSDK.audio();
    }

    @Deprecated
    @NonNull
    public static RecordingService recording() {
        return VoxeetSDK.recording();
    }

    @Deprecated
    @NonNull
    public static CommandService command() {
        return VoxeetSDK.command();
    }

    @Deprecated
    @NonNull
    public static LocalStatsService localStats() {
        return VoxeetSDK.localStats();
    }

    @Deprecated
    @NonNull
    public static NotificationService notification() {
        return VoxeetSDK.notification();
    }

    @Deprecated
    @NonNull
    public static TelemetryService telemetry() {
        return VoxeetSDK.telemetry();
    }

    @Deprecated
    public Context getApplicationContext() {
        return VoxeetSDK.instance().getApplicationContext();
    }

    public AbstractVoxeetEnvironmentHolder getVoxeetEnvironmentHolder() {
        return VoxeetSDK.instance().getVoxeetEnvironmentHolder();
    }

    @Deprecated
    @NonNull
    public EventBus getEventBus() {
        return VoxeetSDK.instance().getEventBus();
    }

    @Deprecated
    public boolean register(@Nullable Object subscriber) {
        return VoxeetSDK.instance().register(subscriber);
    }

    @Deprecated
    public void unregister(@NonNull Object subscriber) {
        VoxeetSDK.instance().unregister(subscriber);
    }
}
