/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import java.util.ArrayList;
import java.util.List;

public class ConferenceUtils {
    public static final int MUTE_FACTOR = 10000;
    public static final int UNMUTE_FACTOR = 1;

    private ConferenceUtils() {
    }

    @Nullable
    public static ConferenceUser findConferenceUserById(@Nullable String userId, @Nullable List<ConferenceUser> users) {
        if (null != users) {
            for (ConferenceUser user : users) {
                if (null == userId || !userId.equalsIgnoreCase(user.getUserId())) continue;
                return user;
            }
        }
        return null;
    }

    @Nullable
    public static User findUserById(@Nullable String userId, @Nullable List<User> users) {
        if (null != users) {
            for (User user : users) {
                if (null == userId || !userId.equalsIgnoreCase(user.getId())) continue;
                return user;
            }
        }
        return null;
    }

    @NonNull
    public static List<User> findUsersMatching(@Nullable String currentUserOrEmpty, @Nullable List<User> merged_list) {
        ArrayList<User> list = new ArrayList<User>();
        if (null != currentUserOrEmpty && null != merged_list) {
            for (User user : merged_list) {
                if (null == user || !currentUserOrEmpty.equalsIgnoreCase(user.getId())) continue;
                list.add(user);
            }
        }
        return list;
    }

    public static List<User> getUserInState(List<User> conferenceUsers, ConferenceUserStatus status) {
        ArrayList<User> users = new ArrayList<User>();
        for (User user : conferenceUsers) {
            if (null == user || !status.equals((Object)user.getStatus())) continue;
            users.add(user);
        }
        return users;
    }

    public static List<ConferenceUser> getConferenceUserInState(List<ConferenceUser> conferenceUsers, ConferenceUserStatus status) {
        ArrayList<ConferenceUser> users = new ArrayList<ConferenceUser>();
        for (ConferenceUser user : conferenceUsers) {
            if (null == user || !status.equals((Object)user.getConferenceStatus())) continue;
            users.add(user);
        }
        return users;
    }
}

