/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.media.sensors;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import com.voxeet.sdk.media.sensors.ConferenceLock;

public class ScreenSensor
implements ConferenceLock {
    private static final int FLAG = 10;
    private PowerManager mPowerManager;
    private Context mContext;
    private PowerManager.WakeLock mProximityWakeLock;
    private Intent registered = null;
    private BroadcastReceiver screenOnReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (ScreenSensor.this.shouldAcquire) {
                ScreenSensor.this.acquire();
            }
        }
    };
    private boolean shouldAcquire = false;

    private ScreenSensor() {
    }

    public ScreenSensor(@NonNull Context context) {
        this();
        this.mContext = context;
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mProximityWakeLock = this.mPowerManager.newWakeLock(10, "Sensor:");
    }

    @Override
    public void acquire() {
        this.shouldAcquire = true;
        try {
            if (null != this.mProximityWakeLock && !this.mProximityWakeLock.isHeld()) {
                this.mProximityWakeLock.acquire();
                this.registered = this.mContext.registerReceiver(this.screenOnReceiver, new IntentFilter("android.intent.action.SCREEN_ON"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void release() {
        this.shouldAcquire = false;
        try {
            if (null != this.mProximityWakeLock && this.mProximityWakeLock.isHeld()) {
                this.mContext.unregisterReceiver(this.screenOnReceiver);
                this.mProximityWakeLock.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isProximity() {
        return false;
    }
}

