/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.media.audio;

import android.content.Context;
import android.media.Ringtone;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.audio.AudioRoute;
import com.voxeet.audio.AudioStackManager;
import com.voxeet.audio.listeners.IAudioRouteListener;
import com.voxeet.sdk.events.sdk.AudioRouteChangeEvent;
import com.voxeet.sdk.media.MediaPowerManager;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.AudioType;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.SoundPool;
import com.voxeet.sdk.utils.Validate;
import java.util.HashMap;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

@Annotate
public class SoundManager
implements IAudioRouteListener {
    private AudioStackManager mAudioManager;
    private MediaPowerManager mMediaPowerManager;
    private Context mContext;
    private HashMap<Integer, SoundPool> _sound_pools;
    private HashMap<AudioType, String> mSounds;
    private boolean mEnable;

    private SoundManager() {
        this.disable();
    }

    @NoDocumentation
    public SoundManager(@NonNull Context context) {
        this();
        this._sound_pools = new HashMap();
        this.mAudioManager = new AudioStackManager(context);
        this.mAudioManager.setMediaRoute();
        this.mAudioManager.configureVolumeStream(0, 3);
        this.mAudioManager.registerAudioRouteListener((IAudioRouteListener)this);
        this.mMediaPowerManager = new MediaPowerManager(context, this.currentRoute());
        this.mContext = context;
        this.mSounds = new HashMap();
        this.configure();
    }

    @NonNull
    public List<AudioRoute> getAvailableRoutes() {
        return this.mAudioManager.availableRoutes();
    }

    @NonNull
    public AudioRoute currentRoute() {
        return this.mAudioManager.outputRoute();
    }

    public boolean setAudioRoute(@NonNull AudioRoute route) {
        Validate.runningOnUiThread();
        return this.mAudioManager.setOutputRoute(route);
    }

    @Nullable
    public Ringtone getSystemRingtone() {
        return this.mAudioManager.getSystemRingtone();
    }

    public boolean isBluetoothHeadsetConnected() {
        return this.mAudioManager.isBluetoothHeadsetConnected();
    }

    public boolean isWiredHeadsetOn() {
        return this.mAudioManager.isWiredHeadsetOn();
    }

    @NonNull
    public SoundManager setSpeakerMode(boolean isSpeaker) {
        this.mAudioManager.setSpeakerMode(isSpeaker);
        return this;
    }

    public boolean isSpeakerOn() {
        return AudioRoute.ROUTE_SPEAKER.equals((Object)this.mAudioManager.outputRoute());
    }

    @NonNull
    public SoundManager acquireLocks() {
        this.mMediaPowerManager.acquire();
        return this;
    }

    @NonNull
    public SoundManager releaseLocks() {
        this.mMediaPowerManager.release();
        return this;
    }

    @NonNull
    public SoundManager resetDefaultSoundType() {
        this.mAudioManager.resetDefaultSoundType();
        return this;
    }

    private int getUiSoundsStreamType() {
        return this.mAudioManager.getDefaultSoundStreamType();
    }

    @NonNull
    private SoundManager forceVolumeControlStream(int type) {
        this.mAudioManager.forceVolumeControlStream(type);
        return this;
    }

    @NonNull
    public SoundManager enableMedia() {
        this.mEnable = true;
        if (null != this.mAudioManager) {
            this.mAudioManager.setMediaRoute();
            this.mAudioManager.enable();
        }
        return this;
    }

    @NonNull
    public SoundManager setMediaRoute() {
        this.mAudioManager.setMediaRoute();
        return this;
    }

    @NonNull
    public SoundManager unsetMediaRoute() {
        this.mAudioManager.unsetMediaRoute();
        return this;
    }

    @NonNull
    public SoundManager abandonAudioFocusRequest() {
        this.mAudioManager.abandonAudioFocus();
        return this;
    }

    @NonNull
    public SoundManager requestAudioFocus() {
        this.mAudioManager.requestAudioFocus();
        return this;
    }

    @NonNull
    public SoundManager checkOutputRoute() {
        if (this.isEnabled()) {
            this.mAudioManager.checkOutputRoute();
        }
        return this;
    }

    private SoundPool getSoundPool(int soundMode) {
        SoundPool pool = this._sound_pools.get(soundMode);
        if (pool == null) {
            pool = new SoundPool(this.mContext, soundMode, this.getVolume(soundMode));
            this._sound_pools.put(soundMode, pool);
        }
        return pool;
    }

    private void configure() {
        this.mAudioManager.disable();
        this.mSounds.put(AudioType.RING, "out.mp3");
        this.mSounds.put(AudioType.HANGUP, "leave.mp3");
        this.setSound(AudioType.RING, this.mSounds.get((Object)AudioType.RING));
        this.setSound(AudioType.HANGUP, this.mSounds.get((Object)AudioType.HANGUP));
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName) {
        return this.setSound(type, assetName, 0);
    }

    public boolean setSound(@NonNull AudioType type, @NonNull String assetName, int soundMode) {
        return this.getSoundPool(soundMode).release(type).setShortResource(type, assetName);
    }

    @NonNull
    public SoundManager playSoundType(@NonNull AudioType type) {
        return this.playSoundType(type, 0);
    }

    @NonNull
    public SoundManager playSoundType(@NonNull AudioType type, int soundMode) {
        if (this.isEnabled()) {
            this.getSoundPool(soundMode).playShortResource(type, this.mSounds.get((Object)type));
        }
        return this;
    }

    @NonNull
    public SoundManager playSoundTypeForce(@NonNull AudioType type) {
        return this.playSoundType(type, 0);
    }

    @NonNull
    public SoundManager playSoundTypeForce(@NonNull AudioType type, int soundMode) {
        this.getSoundPool(soundMode).playShortResource(type, this.mSounds.get((Object)type));
        return this;
    }

    @NonNull
    public SoundManager stopSoundType(@NonNull AudioType audioType) {
        return this.stopSoundType(audioType, 0);
    }

    @NonNull
    public SoundManager stopSoundType(@NonNull AudioType audioType, int soundMode) {
        this.getSoundPool(soundMode).stop(audioType);
        return this;
    }

    @NonNull
    public SoundManager stop(int soundMode) {
        this.getSoundPool(soundMode).stop();
        return this;
    }

    @NonNull
    public SoundManager stop() {
        this.stop(0);
        return this;
    }

    @NonNull
    public SoundManager onConferencePreJoinedEvent() {
        this.mAudioManager.checkOutputRoute();
        return this;
    }

    @NonNull
    public SoundManager onConferenceDestroyedPush() {
        this.abandonAudioFocusRequest();
        return this;
    }

    @NonNull
    public SoundManager enable() {
        this.mEnable = true;
        if (null != this.mAudioManager) {
            this.mAudioManager.enable();
        }
        return this;
    }

    @NonNull
    public SoundManager disable() {
        this.mEnable = false;
        if (null != this.mAudioManager) {
            this.mAudioManager.disable();
        }
        return this;
    }

    private boolean isEnabled() {
        return this.mEnable;
    }

    private float getVolume(int soundMode) {
        switch (soundMode) {
            case 0: {
                return 0.1f;
            }
        }
        return 1.0f;
    }

    @NoDocumentation
    public void onAudioRouteChanged() {
        EventBus.getDefault().post((Object)new AudioRouteChangeEvent());
    }
}

