/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.models.v1.Conference;
import com.voxeet.sdk.models.v1.ConferenceInfos;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.models.v1.UserProfile;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="UserInvited")
public class UserInvited
extends Event {
    @JsonProperty(value="conference")
    public ConferenceInfos conferenceInfos;
    public List<UserProfile> participants;

    public Conference getAsConference() {
        Conference conference = new Conference();
        conference.setConferenceInfos(this.conferenceInfos);
        conference.setHasBeenCreated(true);
        conference.setDemo(false);
        conference.setConferenceType(this.conferenceInfos.getConferenceType());
        conference.setMeetingId(this.conferenceInfos.getMeetingId());
        conference.setConferenceId(this.conferenceInfos.getConferenceId());
        conference.setDescription(this.conferenceInfos.getDescription());
        conference.setLocation(this.conferenceInfos.getLocation());
        conference.setGuestAccess(false);
        conference.setOffline(false);
        conference.setRecorded(false);
        conference.setRecordingStatus(RecordingStatus.NOT_RECORDING);
        for (UserProfile profile : this.participants) {
            conference.getConferenceUsers().add(new ConferenceUser(profile));
        }
        return conference;
    }

    @Override
    public String getType() {
        return "UserInvited";
    }
}

