/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.authent.token.Authentication;
import com.voxeet.sdk.json.Event;
import java.util.TimeZone;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="Login")
public class LoginEvent
extends Event {
    private String login;
    private String password;
    private String timezone;
    private String devicePushToken;
    private String deviceType;
    private String deviceIdentifier;

    public LoginEvent(String login, String password, String devicePushToken, String deviceIdentifier) {
        this.login = login;
        this.password = Authentication.compute((String)password);
        this.timezone = TimeZone.getDefault().getID();
        this.devicePushToken = devicePushToken;
        this.deviceType = "ANDROID";
        this.deviceIdentifier = deviceIdentifier;
    }

    public String getDevicePushToken() {
        return this.devicePushToken;
    }

    public void setDevicePushToken(String devicePushToken) {
        this.devicePushToken = devicePushToken;
    }

    public String getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public void setDeviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Override
    public String getType() {
        return "Login";
    }
}

