/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.media;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.MediaStream;
import com.voxeet.sdk.media.MediaSDK;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoSink;

public class VideoSinkHolder {
    private MediaSDK media;
    @NonNull
    private WeakReference<VideoRenderer.Callbacks> holder;
    private ArrayList<MediaStreamListener> mediaStreamListeners = new ArrayList();

    private VideoSinkHolder() {
    }

    public VideoSinkHolder(MediaSDK media, @NonNull VideoRenderer.Callbacks videoSink) {
        this();
        this.media = media;
        this.holder = new WeakReference<VideoRenderer.Callbacks>(videoSink);
    }

    public boolean hasVideoSink() {
        return this.holder.get() != null;
    }

    public void clear() {
        this.unattach();
        this.media = null;
    }

    @Nullable
    public MediaStream getMediaStream() {
        for (MediaStreamListener listener : this.mediaStreamListeners) {
            if (!listener.active) continue;
            return listener.mediaStream;
        }
        return null;
    }

    public void attach(@NonNull MediaStream stream) {
        VideoRenderer.Callbacks videoSink = (VideoRenderer.Callbacks)this.holder.get();
        this.unattach();
        if (null != videoSink) {
            MediaStreamListener mediaStreamListener = new MediaStreamListener(stream);
            this.media.attachMediaStream(mediaStreamListener, stream);
            this.mediaStreamListeners.add(mediaStreamListener);
        }
    }

    public void unattach() {
        VideoRenderer.Callbacks videoSink = (VideoRenderer.Callbacks)this.holder.get();
        for (MediaStreamListener mediaStreamListener : this.mediaStreamListeners) {
            if (null != videoSink) {
                this.media.unattachMediaStream(mediaStreamListener, mediaStreamListener.mediaStream);
            }
            mediaStreamListener.active = false;
        }
        this.mediaStreamListeners.clear();
    }

    public boolean isAttachedTo(@NonNull MediaStream mediaStream) {
        for (MediaStreamListener mediaStreamListener : this.mediaStreamListeners) {
            if (mediaStreamListener.mediaStream != mediaStream || !mediaStreamListener.active) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object obj) {
        VideoRenderer.Callbacks videoSink = (VideoRenderer.Callbacks)this.holder.get();
        return obj == this || obj instanceof VideoSink && obj.equals(videoSink);
    }

    private class MediaStreamListener
    implements VideoRenderer.Callbacks {
        public MediaStream mediaStream;
        public boolean active;

        public MediaStreamListener(MediaStream mediaStream) {
            this.mediaStream = mediaStream;
            this.active = true;
        }

        public void renderFrame(VideoRenderer.I420Frame frame) {
            VideoRenderer.Callbacks videoSink = (VideoRenderer.Callbacks)VideoSinkHolder.this.holder.get();
            if (this.active) {
                if (null != videoSink) {
                    videoSink.renderFrame(frame);
                }
            } else if (null != videoSink && null != VideoSinkHolder.this.media) {
                VideoSinkHolder.this.media.unattachMediaStream(videoSink, this.mediaStream);
            }
        }
    }
}

