/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.localstats;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.voxeet.sdk.core.services.localstats.LocalStatsRunnable;
import java.util.concurrent.locks.ReentrantLock;

public class LocalStatsHandler {
    private static final String TAG = LocalStatsHandler.class.getSimpleName();
    private long mLoop;
    private Runnable mCallback;
    private Handler mHandler;
    private ReentrantLock mLock;
    private LocalStatsRunnable mRunnable;
    private boolean mStopped;

    public LocalStatsHandler(@NonNull Runnable callback, long loop) {
        this.mCallback = callback;
        this.mStopped = true;
        this.mLoop = loop;
        this.mLock = new ReentrantLock();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public boolean startAutoFetch() {
        this.mLock.lock();
        if (null == this.mRunnable) {
            this.mRunnable = new LocalStatsRunnable(){

                @Override
                public void run() {
                    boolean post = false;
                    LocalStatsHandler.this.mLock.lock();
                    try {
                        LocalStatsHandler.this.mCallback.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    LocalStatsRunnable instance = LocalStatsHandler.this.mRunnable;
                    if (null != instance && this.getToken() == instance.getToken()) {
                        post = true;
                    }
                    LocalStatsHandler.this.mLock.unlock();
                    Handler handler = LocalStatsHandler.this.mHandler;
                    if (null != handler) {
                        handler.removeCallbacks((Runnable)this);
                        if (post && !LocalStatsHandler.this.mStopped) {
                            handler.postDelayed((Runnable)this, LocalStatsHandler.this.mLoop);
                        }
                    }
                }
            };
            this.mStopped = false;
            this.mLock.unlock();
            this.mHandler.post((Runnable)this.mRunnable);
            return true;
        }
        this.mLock.unlock();
        return false;
    }

    public boolean stopAutoFetch() {
        this.mStopped = true;
        this.mLock.lock();
        if (null != this.mRunnable) {
            LocalStatsRunnable instance = this.mRunnable;
            this.mHandler.removeCallbacks((Runnable)instance);
            this.mHandler = null;
            this.mRunnable = null;
            this.mLock.unlock();
            return true;
        }
        this.mLock.unlock();
        return false;
    }
}

