/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class StopRecordingPromiseable
extends AbstractPromiseable<Boolean> {
    public StopRecordingPromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    ConferenceInformation information = StopRecordingPromiseable.this.getInformation();
                    if (null == information || null == information.getConference().getId()) {
                        throw new NotInConferenceException();
                    }
                    Call<ResponseBody> user = StopRecordingPromiseable.this.getProvider().getStopRecordingObservable(information.getConference().getId());
                    HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            if (response.code() == 200) {
                                StopRecordingPromiseable.this.log("Conference recording stopped");
                            }
                            try {
                                StopRecordingPromiseable.this.log("onNext: " + ((ResponseBody)response.body()).string());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            solver.resolve(response.code() == 200);
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);
                            StopRecordingPromiseable.this.log("Failed to cancel mConference recording");
                            solver.reject(e);
                        }
                    });
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    solver.reject(e);
                }
            }
        });
    }
}

