/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.core.services.AbstractPromiseable;
import com.voxeet.sdk.core.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.core.services.MediaDeviceService;
import com.voxeet.sdk.core.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.PromiseDeclineConferenceResultEventException;
import com.voxeet.sdk.events.sdk.DeclineConferenceResultEvent;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class DeclinePromise
extends AbstractPromiseable<DeclineConferenceResultEvent> {
    private static final String TAG = DeclinePromise.class.getSimpleName();
    private final String conferenceId;

    public DeclinePromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull String conferenceId) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.conferenceId = conferenceId;
    }

    @Override
    @NonNull
    public Promise<DeclineConferenceResultEvent> createPromise() {
        return new Promise<DeclineConferenceResultEvent>(new PromiseSolver<DeclineConferenceResultEvent>(){

            @Override
            public void onCall(final @NonNull Solver<DeclineConferenceResultEvent> solver) {
                Call<ResponseBody> user = DeclinePromise.this.getProvider().getDeclineObservable(DeclinePromise.this.conferenceId);
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        Log.d((String)TAG, (String)("IConference declined with id: " + DeclinePromise.this.conferenceId));
                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(response.code() == 200);
                        DeclinePromise.this.getEventBus().post((Object)event);
                        solver.resolve(event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable t, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        t.printStackTrace();
                        DeclineConferenceResultEvent event = new DeclineConferenceResultEvent(false);
                        DeclinePromise.this.getEventBus().post((Object)event);
                        solver.reject(new PromiseDeclineConferenceResultEventException(event));
                    }
                });
            }
        });
    }
}

