/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.Gson;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.services.SDKVideoPresentationService;
import com.voxeet.sdk.events.BaseEvent;
import com.voxeet.sdk.events.error.SocketErrorEvent;
import com.voxeet.sdk.events.sdk.MessageReceived;
import com.voxeet.sdk.events.sdk.SocketConnectEvent;
import com.voxeet.sdk.events.sdk.SocketDisconnectEvent;
import com.voxeet.sdk.events.sdk.SocketStateChangeEvent;
import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.json.BroadcastEvent;
import com.voxeet.sdk.json.ConferenceMessageReceived;
import com.voxeet.sdk.json.ConferenceStats;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.FileConverted;
import com.voxeet.sdk.json.FilePresentationStarted;
import com.voxeet.sdk.json.FilePresentationStopped;
import com.voxeet.sdk.json.FilePresentationUpdated;
import com.voxeet.sdk.json.InterfaceEvent;
import com.voxeet.sdk.json.VideoPresentationPaused;
import com.voxeet.sdk.json.VideoPresentationPlay;
import com.voxeet.sdk.json.VideoPresentationSeek;
import com.voxeet.sdk.json.VideoPresentationStarted;
import com.voxeet.sdk.json.VideoPresentationStopped;
import org.greenrobot.eventbus.EventBus;

public class VoxeetDispatcher {
    private static final String TAG = VoxeetDispatcher.class.getSimpleName();
    private static EventBus eventBus = EventBus.getDefault();

    public static void dispatch(String eventName, String message) {
        Log.d((String)TAG, (String)("dispatch: " + eventName + " := " + message));
        try {
            InterfaceEvent event;
            switch (eventName) {
                case "SOCKET_DISCONNECTED": {
                    event = VoxeetDispatcher.handleDisconnect(message);
                    break;
                }
                case "SOCKET_ERROR": {
                    event = VoxeetDispatcher.handleError(message);
                    break;
                }
                case "SOCKET_TEXT": {
                    event = VoxeetDispatcher.handleMessage(message);
                    break;
                }
                case "SOCKET_CONNECTED": {
                    event = VoxeetDispatcher.handleSocketConnect(message);
                    break;
                }
                case "SOCKET_STATE_CHANGE": {
                    event = VoxeetDispatcher.handleStateChange(message);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown event type");
                }
            }
            if (null != event) {
                eventBus.post((Object)event);
            } else {
                Log.d((String)TAG, (String)"dispatch: event internally managed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BaseEvent handleError(String message) {
        return new SocketErrorEvent(message);
    }

    private static BaseEvent handleDisconnect(String message) {
        return new SocketDisconnectEvent(message);
    }

    private static BaseEvent handleStateChange(String message) {
        return new SocketStateChangeEvent(message);
    }

    private static BaseEvent handleSocketConnect(String message) {
        return new SocketConnectEvent(message);
    }

    @Nullable
    private static InterfaceEvent handleMessage(String message) {
        InterfaceEvent busEvent;
        Event event = EventsFactory.decode(message);
        switch (event.getType()) {
            case "OfferCreated": {
                busEvent = event;
                break;
            }
            case "ConferenceMessageReceived": {
                busEvent = VoxeetDispatcher.handleConferenceMessage((ConferenceMessageReceived)event);
                break;
            }
            case "BroadcastEvent": {
                busEvent = VoxeetDispatcher.handleBroadcast((BroadcastEvent)event);
                break;
            }
            case "ConferenceDestroyedPush": 
            case "ProfileUpdatedEvent": 
            case "ParticipantUpdated": 
            case "OwnConferenceCreatedEvent": 
            case "OwnExternalInvitationsSentEvent": 
            case "OwnContactRemovedEvent": 
            case "RenegociationEnded": 
            case "RecordingStatusUpdated": 
            case "InvitationReceivedEvent": 
            case "FileDeletedEvent": 
            case "FileSharedEvent": 
            case "QualityUpdated": 
            case "WhisperInvitationReceivedEvent": 
            case "WhisperAcceptedEvent": 
            case "WhisperDeclinedEvent": 
            case "WhisperLeftEvent": 
            case "OwnUserInvitedEvent": 
            case "UserInvited": 
            case "ParticipantSwitched": 
            case "ParticipantAdded": 
            case "OwnParticipantSwitched": 
            case "ConferenceEndedEvent": 
            case "ConferenceStatusUpdated": 
            case "ContactsAddedEvent": 
            case "PeerConnectionStatusUpdatedEvent": {
                busEvent = event;
                break;
            }
            case "FileConvertedEvent": {
                busEvent = (FileConverted)event;
                break;
            }
            case "FilePresentationStarted": {
                busEvent = (FilePresentationStarted)event;
                break;
            }
            case "FilePresentationStopped": {
                busEvent = (FilePresentationStopped)event;
                break;
            }
            case "FilePresentationUpdated": {
                busEvent = (FilePresentationUpdated)event;
                break;
            }
            case "VideoPresentationStarted": 
            case "VideoPresentationStopped": 
            case "VideoPresentationPlay": 
            case "VideoPresentationPause": 
            case "VideoPresentationSeek": {
                VoxeetDispatcher.handleVideoPresentation(event);
                return null;
            }
            case "ConferenceStats": {
                busEvent = (InterfaceEvent)new Gson().fromJson(message, ConferenceStats.class);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type of event");
            }
        }
        return busEvent;
    }

    private static InterfaceEvent handleConferenceMessage(ConferenceMessageReceived event) {
        Event event1 = EventsFactory.decode(event.message);
        if (event1 == null) {
            return new MessageReceived(event.userId, event.conferenceId, event.message);
        }
        switch (event1.getType()) {
            case "VideoPresentationStarted": 
            case "VideoPresentationStopped": 
            case "VideoPresentationPlay": 
            case "VideoPresentationPause": 
            case "VideoPresentationSeek": {
                VoxeetDispatcher.handleVideoPresentation(event1);
                return null;
            }
        }
        return new MessageReceived(event.userId, event.conferenceId, event.message);
    }

    private static void handleVideoPresentation(@NonNull Event event) {
        SDKVideoPresentationService service = VoxeetSdk.videoPresentation();
        if (null == service) {
            Log.d((String)TAG, (String)"handleVideoPresentation: invalid service state");
            return;
        }
        switch (event.getType()) {
            case "VideoPresentationStarted": {
                service.onInternalServiceEvent((VideoPresentationStarted)event);
                return;
            }
            case "VideoPresentationStopped": {
                service.onInternalServiceEvent((VideoPresentationStopped)event);
                return;
            }
            case "VideoPresentationPlay": {
                service.onInternalServiceEvent((VideoPresentationPlay)event);
                return;
            }
            case "VideoPresentationPause": {
                service.onInternalServiceEvent((VideoPresentationPaused)event);
                return;
            }
            case "VideoPresentationSeek": {
                service.onInternalServiceEvent((VideoPresentationSeek)event);
                return;
            }
        }
    }

    private static InterfaceEvent handleBroadcast(BroadcastEvent event) {
        Event event1 = EventsFactory.decode(event.message);
        switch (event1.getType()) {
            case "TypingDetection": {
                return event1;
            }
        }
        throw new IllegalStateException("Unknown broadcast type event");
    }
}

