/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.core.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.log.factory.LogFactory;
import com.voxeet.sdk.core.AbstractVoxeetService;
import com.voxeet.sdk.core.VoxeetHttp;
import com.voxeet.sdk.core.VoxeetSdk;
import com.voxeet.sdk.core.network.endpoints.IUserRService;
import com.voxeet.sdk.core.network.websocket.VoxeetWebSocket;
import com.voxeet.sdk.core.preferences.VoxeetPreferences;
import com.voxeet.sdk.core.services.ConferenceService;
import com.voxeet.sdk.events.error.GetUploadTokenErrorEvent;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.NewLoginRequiredEvent;
import com.voxeet.sdk.events.error.SdkLogoutErrorEvent;
import com.voxeet.sdk.events.error.SocketConnectErrorEvent;
import com.voxeet.sdk.events.sdk.SdkLogoutSuccessEvent;
import com.voxeet.sdk.events.sdk.SocketConnectEvent;
import com.voxeet.sdk.events.success.GetTokenUploadSuccessResult;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.NoDocumentation;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Annotate
public class SessionService
extends AbstractVoxeetService<IUserRService> {
    private static final String TAG = SessionService.class.getSimpleName();
    private final VoxeetSdk instance;
    private VoxeetWebSocket _voxeet_websocket;
    private List<Solver<Boolean>> mWaitForLogInSocket;
    private ReentrantLock lockConnectAttempt = new ReentrantLock();
    @Nullable
    private UserInfo _user_info;

    @NoDocumentation
    public SessionService(VoxeetSdk instance) {
        super(instance, IUserRService.class);
        this.instance = instance;
        this.mWaitForLogInSocket = new ArrayList<Solver<Boolean>>();
        this._voxeet_websocket = new VoxeetWebSocket(instance, instance.getVoxeetEnvironmentHolder().getSocketUrl());
        this.registerEventBus();
    }

    public void connectSocket(VoxeetHttp provider) {
        this._voxeet_websocket.connect(provider);
    }

    @Deprecated
    @NoDocumentation
    public final void getUploadToken() {
        Call<GetTokenUploadSuccessResult> user = ((IUserRService)this.getService()).getUploadToken();
        user.enqueue((Callback)new Callback<GetTokenUploadSuccessResult>(){

            public void onResponse(Call<GetTokenUploadSuccessResult> call, Response<GetTokenUploadSuccessResult> response) {
                if (response.isSuccessful()) {
                    SessionService.this.getEventBus().post(response);
                    VoxeetPreferences.setUploadToken(((GetTokenUploadSuccessResult)response.body()).getUploadToken());
                } else {
                    SessionService.this.getEventBus().post((Object)new NewLoginRequiredEvent("New login required"));
                }
            }

            public void onFailure(Call<GetTokenUploadSuccessResult> call, Throwable e) {
                SessionService.this.getEventBus().post((Object)new GetUploadTokenErrorEvent(SessionService.this.handleError(e)));
            }
        });
    }

    @NonNull
    public Promise<Boolean> open(@NonNull UserInfo userInfo) {
        this._user_info = userInfo;
        return this.open();
    }

    @NonNull
    public Promise<Boolean> open() {
        if (null == this._user_info) {
            this.rejectUserNull("login");
        }
        if (this.isSocketOpen()) {
            return new Promise<Boolean>(new PromiseSolver<Boolean>(){

                @Override
                public void onCall(@NonNull Solver<Boolean> solver) {
                    Log.d((String)TAG, (String)"onCall: socket opened");
                    SessionService.this.lockConnectAttempt();
                    SessionService.this.resolveLoginSockets();
                    SessionService.this.unlockConnectAttempt();
                    solver.resolve(true);
                }
            });
        }
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(@NonNull Solver<Boolean> solver) {
                if (null != SessionService.this._voxeet_websocket && SessionService.this.isSocketOpen()) {
                    SessionService.this._voxeet_websocket.close(true);
                }
                Log.d((String)TAG, (String)"onCall: start login in promise");
                SessionService.this.lockConnectAttempt();
                Log.d((String)TAG, (String)("onCall: having the list with elements := " + SessionService.this.mWaitForLogInSocket));
                if (SessionService.this.mWaitForLogInSocket.size() == 0) {
                    SessionService.this.mWaitForLogInSocket.add(solver);
                    SessionService.this.unlockConnectAttempt();
                    SessionService.this.IdentifyInlogin().then(new PromiseExec<Boolean, Object>(){

                        @Override
                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                            Log.d((String)TAG, (String)"onCall: first login part done");
                        }
                    }).error(new ErrorPromise(){

                        @Override
                        public void onError(@NonNull Throwable error) {
                            Log.d((String)TAG, (String)("onError: login error " + error.getMessage()));
                            SessionService.this.lockConnectAttempt();
                            SessionService.this.rejectLoginSockets(error);
                            SessionService.this.clearLoginSockets();
                            SessionService.this.unlockConnectAttempt();
                            Log.d((String)TAG, (String)"onError: login error managed");
                        }
                    });
                } else {
                    Log.d((String)TAG, (String)"onCall: already have a login attempt in progress");
                    try {
                        throw new IllegalStateException("Can not open a session while an other one is trying to be started");
                    }
                    catch (Exception e) {
                        solver.reject(e);
                        SessionService.this.unlockConnectAttempt();
                    }
                }
                Log.d((String)TAG, (String)"onCall: start login done... can take a time");
            }
        });
    }

    public void closeSocket() {
        this._voxeet_websocket.close(true);
    }

    @Deprecated
    @NoDocumentation
    public void cleanUserSession(@NonNull String id) {
        this.getVoxeetHttp(this.instance).cleanUserSession(id);
    }

    public boolean isSocketOpen() {
        return this._voxeet_websocket.isOpen();
    }

    @Nullable
    public UserInfo getUserInfo() {
        return this._user_info;
    }

    @Nullable
    public String getUserId() {
        return VoxeetPreferences.id();
    }

    @Nullable
    public User getUser() {
        String userId = this.getUserId();
        UserInfo userInfo = this.getUserInfo();
        return null != userId ? new User(userId, userInfo) : null;
    }

    public boolean isLocalUser(@NonNull User user) {
        String id = user.getId();
        return null != id && id.equals(this.getUserId());
    }

    @NonNull
    public Promise<Boolean> close() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                LogFactory.instance.disconnect();
                Log.d((String)TAG, (String)"onCall: logout called");
                SessionService.this.lockConnectAttempt();
                try {
                    throw new IllegalStateException("You have awaiting login, the logout automatically canceled those");
                }
                catch (Exception e) {
                    SessionService.this.rejectLoginSockets(e);
                    SessionService.this.clearLoginSockets();
                    SessionService.this.unlockConnectAttempt();
                    try {
                        ConferenceService service = VoxeetSdk.conference();
                        service.clearConferencesInformation();
                        if (null != service && service.isLive()) {
                            service.leave().then(new PromiseExec<Boolean, Object>(){

                                @Override
                                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                                    Log.d((String)TAG, (String)"onCall: leaving while logging out done");
                                }
                            }).error(new ErrorPromise(){

                                @Override
                                public void onError(@NonNull Throwable error) {
                                    Log.d((String)TAG, (String)"onError: leaving when logout error -- for information :");
                                    error.printStackTrace();
                                }
                            });
                        }
                    }
                    catch (Exception e2) {
                        Log.d((String)TAG, (String)"onCall: WARNING :: please report this error :");
                        e2.printStackTrace();
                    }
                    Log.d((String)TAG, (String)"onCall: clean awaiting sockets done");
                    SessionService.this.internalLogout().then(new PromiseExec<Boolean, Object>(){

                        @Override
                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> s) {
                            Log.d((String)TAG, (String)("onCall: logout result := " + result + " ... propagating..."));
                            solver.resolve(result);
                        }
                    }).error(new ErrorPromise(){

                        @Override
                        public void onError(@NonNull Throwable error) {
                            solver.reject(error);
                        }
                    });
                    return;
                }
            }
        });
    }

    private Promise<Boolean> internalLogout() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                final String id = SessionService.this.getUserId();
                if (null != id) {
                    Log.d((String)TAG, (String)"Attempting to logout");
                    Call<ResponseBody> user = ((IUserRService)SessionService.this.getService()).logout(VoxeetPreferences.token());
                    HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            VoxeetPreferences.onLogout();
                            SessionService.this.closeSocket();
                            SessionService.this.cleanUserSession(id);
                            if (response.code() == 200) {
                                String message = "Logout success";
                                SessionService.this.getEventBus().post((Object)new SdkLogoutSuccessEvent(message));
                                solver.resolve(true);
                            } else {
                                String message = "Logout failed";
                                SessionService.this.getEventBus().post((Object)new SdkLogoutErrorEvent(message));
                                solver.resolve(false);
                            }
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            HttpException.dumpErrorResponse(response);
                            e.printStackTrace();
                            String message = "Logout failed";
                            VoxeetPreferences.onLogout();
                            VoxeetSdk.session().closeSocket();
                            VoxeetSdk.session().cleanUserSession(id);
                            SessionService.this.getEventBus().post((Object)new SdkLogoutErrorEvent(SessionService.this.handleError(e)));
                            solver.reject(e);
                        }
                    });
                } else {
                    String message = "Already logged out";
                    Log.d((String)TAG, (String)"Already logged out");
                    SessionService.this.getEventBus().post((Object)new SdkLogoutSuccessEvent("Already logged out"));
                    solver.resolve(true);
                }
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectEvent event) {
        this.lockConnectAttempt();
        this.resolveLoginSockets();
        this.unlockConnectAttempt();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectErrorEvent event) {
        this.lockConnectAttempt();
        for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
            Log.d((String)TAG, (String)"onEvent: calling resolved false");
            Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
            try {
                solver.resolve(false);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.clearLoginSockets();
        this.unlockConnectAttempt();
    }

    @NonNull
    private Promise<Boolean> IdentifyInlogin() {
        if (null == this._user_info) {
            return this.rejectUserNull("on login attempt");
        }
        return this.getVoxeetHttp(this.instance).identifyChain(this._user_info);
    }

    protected VoxeetWebSocket getSocket() {
        return this._voxeet_websocket;
    }

    private void lockConnectAttempt() {
        try {
            this.lockConnectAttempt.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unlockConnectAttempt() {
        try {
            if (this.lockConnectAttempt.isLocked()) {
                this.lockConnectAttempt.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void rejectLoginSockets(@Nullable Throwable error) {
        try {
            for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
                Log.d((String)TAG, (String)"onError: calling reject");
                Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
                try {
                    solver.reject(error);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void resolveLoginSockets() {
        try {
            for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
                Log.d((String)TAG, (String)"onEvent: calling resolved true");
                Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
                try {
                    solver.resolve(true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clearLoginSockets();
    }

    private void clearLoginSockets() {
        try {
            this.mWaitForLogInSocket.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Promise<Boolean> rejectUserNull(final @NonNull String origin) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(@NonNull Solver<Boolean> solver) {
                try {
                    throw new IllegalStateException("Invalid ! user not set ! sent from " + origin);
                }
                catch (Exception e) {
                    solver.reject(e);
                    return;
                }
            }
        });
    }
}

