package org.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.NonNull;

import java.util.ArrayList;

import javax.annotation.Nullable;

public final class MediaCodecVideoHelperFactory {
    public final static String TAG = MediaCodecVideoHelperFactory.class.getSimpleName();

    private MediaCodecVideoHelperFactory() {

    }

    @NonNull
    public static ArrayList<MediaCodecInfo> getCodecs() {
        ArrayList<MediaCodecInfo> list = new ArrayList<>();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
                MediaCodecInfo info = null;
                try {
                    list.add(MediaCodecList.getCodecInfoAt(i));
                } catch (IllegalArgumentException e) {
                    Logging.e(TAG, "Cannot retrieve decoder codec info", e);
                }
            }
        }

        return list;
    }
    //unused for now
    @Nullable
    private static MediaCodecInfo findCodecForType(VideoCodecType type, @NonNull ValidateMediaCodecInfo validate) {
        // HW decoding is not supported on builds before KITKAT.
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {
            return null;
        }

        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt(i);
            } catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", e);
            }

            if (info == null || validate.isValid(info)) {
                continue;
            }

            if (validate.isSupportedCodec(info, type)) {
                return info;
            }
        }

        return null; // No support for this type.
    }

    private abstract class ValidateMediaCodecInfo {
        private int[] color_formats;

        private ValidateMediaCodecInfo() {

        }

        public ValidateMediaCodecInfo(int[] color_formats) {
            this.color_formats = color_formats;
        }

        // Returns true if the given MediaCodecInfo indicates a supported encoder for the given type.
        private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
            if (!MediaCodecUtils.codecSupportsType(info, type)) {
                return false;
            }
            // Check for a supported color format.
            if (MediaCodecUtils.selectColorFormat(color_formats, info.getCapabilitiesForType(type.mimeType()))
                    == null) {
                return false;
            }
            return isValid(info, type);
        }

        abstract boolean isValid(@NonNull MediaCodecInfo info);

        abstract boolean isValid(@NonNull MediaCodecInfo info, @NonNull VideoCodecType type);
    }
}
